/*
 * Decompiled with CFR 0.152.
 */
package DNATools;

public class DNAElementFinder {
    private static final int CAP_MINLEN = 20;
    private static final int MEF_MINLEN = 12;
    private static final int PROK10_MINLEN = 6;
    private static final int PROK35_MINLEN = 6;
    private static final int KOZAK_MINLEN = 9;
    private static final int GTAG_SD_MINLEN = 8;
    private static final int GCAG_SD_MINLEN = 8;
    private static final int GTAG_SA_MINLEN = 15;
    private static final int GCAG_SA_MINLEN = 15;
    private static final float[][] Matrix_Prok10 = new float[][]{{0.09f, 3.17f, 1.05f, 2.14f, 2.01f, 0.1f}, {2.69f, 0.29f, 1.56f, 0.6f, 0.38f, 3.21f}, {0.04f, 0.04f, 0.56f, 0.6f, 1.05f, 0.22f}, {0.33f, 0.03f, 0.63f, 0.42f, 0.43f, 0.06f}, {2.69f, 3.17f, 1.56f, 2.14f, 2.01f, 3.21f}};
    private static final float[][] Matrix_Prok35 = new float[][]{{0.78f, 0.27f, 0.94f, 1.36f, 1.29f, 1.32f}, {2.14f, 2.51f, 0.55f, 0.8f, 0.58f, 0.96f}, {0.49f, 0.9f, 0.0f, 1.14f, 1.8f, 0.62f}, {0.3f, 0.06f, 2.68f, 0.65f, 0.37f, 1.01f}, {2.14f, 2.51f, 2.68f, 1.36f, 1.8f, 1.32f}};
    private static final float[][] Matrix_Kozak = new float[][]{{0.2f, 0.2f, 0.21f, 0.21f, 0.19f, 0.24f, 0.46f, 0.29f, 0.19f}, {0.18f, 0.18f, 0.19f, 0.17f, 0.19f, 0.12f, 0.07f, 0.13f, 0.08f}, {0.27f, 0.33f, 0.32f, 0.23f, 0.32f, 0.38f, 0.1f, 0.38f, 0.45f}, {0.35f, 0.29f, 0.28f, 0.39f, 0.3f, 0.26f, 0.37f, 0.2f, 0.28f}, {0.35f, 0.33f, 0.32f, 0.39f, 0.32f, 0.38f, 0.46f, 0.38f, 0.45f}};
    private static final float[][] Matrix_GTAG_SD = new float[][]{{34.0f, 60.4f, 9.2f, 0.0f, 0.0f, 52.6f, 71.3f, 7.1f, 16.0f}, {11.4f, 14.2f, 7.3f, 0.0f, 100.0f, 2.5f, 9.3f, 5.9f, 46.2f}, {36.3f, 12.9f, 3.3f, 0.0f, 0.0f, 2.8f, 7.6f, 5.5f, 16.5f}, {18.3f, 12.5f, 80.3f, 100.0f, 0.0f, 41.9f, 11.8f, 81.4f, 20.9f}, {36.3f, 60.4f, 80.3f, 100.0f, 100.0f, 52.6f, 71.3f, 81.4f, 46.2f}};
    private static final float[][] Matrix_GCAG_SD = new float[][]{{40.5f, 88.9f, 1.6f, 0.0f, 0.0f, 87.3f, 84.1f, 1.6f, 7.9f}, {1.6f, 8.7f, 0.0f, 0.0f, 0.0f, 0.0f, 6.3f, 0.8f, 70.6f}, {42.1f, 0.8f, 0.8f, 0.0f, 100.0f, 0.0f, 3.2f, 0.8f, 11.9f}, {15.9f, 1.6f, 97.6f, 100.0f, 0.0f, 12.7f, 6.3f, 96.8f, 9.5f}, {42.1f, 88.9f, 97.6f, 100.0f, 100.0f, 87.3f, 84.1f, 96.8f, 70.6f}};
    private static final float[][] Matrix_GTAG_SA = new float[][]{{9.0f, 8.4f, 7.5f, 6.8f, 7.6f, 8.0f, 9.7f, 9.2f, 7.6f, 7.8f, 23.7f, 4.2f, 100.0f, 0.0f, 23.9f}, {42.3f, 44.0f, 47.0f, 49.4f, 47.1f, 46.3f, 40.8f, 42.9f, 44.5f, 50.4f, 24.0f, 24.6f, 0.0f, 0.0f, 10.4f}, {31.0f, 31.0f, 30.7f, 29.3f, 32.6f, 33.0f, 37.3f, 38.5f, 41.0f, 35.2f, 30.9f, 70.8f, 0.0f, 0.0f, 13.8f}, {12.5f, 11.5f, 10.6f, 10.4f, 11.0f, 11.3f, 11.3f, 8.5f, 6.6f, 6.4f, 21.2f, 3.0f, 0.0f, 100.0f, 52.0f}, {42.3f, 44.0f, 47.0f, 49.4f, 47.1f, 46.3f, 40.8f, 42.9f, 44.5f, 50.4f, 30.9f, 70.8f, 100.0f, 100.0f, 52.0f}};
    private static final float[][] Matrix_GCAG_SA = new float[][]{{11.1f, 12.7f, 3.2f, 4.8f, 12.7f, 8.7f, 16.7f, 16.7f, 12.7f, 9.5f, 26.2f, 6.3f, 100.0f, 0.0f, 21.4f}, {38.9f, 41.3f, 58.7f, 55.6f, 42.1f, 40.5f, 30.9f, 37.3f, 44.4f, 47.6f, 27.0f, 25.4f, 0.0f, 0.0f, 7.9f}, {36.5f, 30.9f, 19.1f, 23.0f, 34.9f, 39.7f, 34.9f, 40.5f, 40.5f, 36.5f, 33.3f, 68.2f, 0.0f, 0.0f, 17.9f}, {9.5f, 10.3f, 15.1f, 12.7f, 8.7f, 9.5f, 16.7f, 4.8f, 2.4f, 6.3f, 13.5f, 0.0f, 0.0f, 100.0f, 62.7f}, {38.9f, 41.3f, 58.7f, 55.6f, 42.1f, 40.5f, 34.9f, 40.5f, 44.4f, 47.6f, 33.3f, 68.2f, 100.0f, 100.0f, 62.7f}};
    private static final float[][] Matrix_SD = new float[][]{{0.27f, 0.38f, 0.76f, 0.0f, 0.0f, 0.85f, 0.19f}, {0.38f, 0.0f, 0.1f, 0.0f, 0.0f, 0.11f, 0.15f}, {0.15f, 0.3f, 0.07f, 0.0f, 0.02f, 0.02f, 0.06f}, {0.2f, 0.32f, 0.07f, 0.99f, 0.98f, 0.02f, 0.6f}, {0.38f, 0.32f, 0.76f, 0.99f, 0.98f, 0.85f, 0.6f}};

    public static float getSequenceScore(String sequence, ElementType elementMatrix) {
        float outVal = 0.0f;
        switch (elementMatrix) {
            case GTAG_INTRON_SPLICE_ACCEPTOR: {
                if (sequence.length() != 15) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_GTAG_SA);
            }
            case GCAG_INTRON_SPLICE_ACCEPTOR: {
                if (sequence.length() != 15) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_GCAG_SA);
            }
            case GTAG_INTRON_SPLICE_DONOR: {
                if (sequence.length() != 8) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_GTAG_SD);
            }
            case GCAG_INTRON_SPLICE_DONOR: {
                if (sequence.length() != 8) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_GCAG_SD);
            }
            case KOZAK_SIGNAL: {
                if (sequence.length() != 9) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_Kozak);
            }
            case PROK_PROMOTER_35: {
                if (sequence.length() != 6) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_Prok35);
            }
            case PROK_PROMOTER_10: {
                if (sequence.length() != 6) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_Prok10);
            }
            case SHINE_DALGARNO: {
                if (sequence.length() != 6) break;
                return DNAElementFinder.scoreSequence(sequence, Matrix_SD);
            }
        }
        return 0.0f;
    }

    private static float scoreSequence(String seq, float[][] scoreMatrix) {
        float seqScore = 0.0f;
        float maxScore = 0.0f;
        char[] seqChar = seq.toLowerCase().toCharArray();
        for (int x = 0; x < seqChar.length; ++x) {
            switch (seqChar[x]) {
                case 'a': {
                    seqScore += scoreMatrix[0][x];
                    break;
                }
                case 't': {
                    seqScore += scoreMatrix[1][x];
                    break;
                }
                case 'c': {
                    seqScore += scoreMatrix[2][x];
                    break;
                }
                case 'g': {
                    seqScore += scoreMatrix[3][x];
                    break;
                }
            }
            maxScore += scoreMatrix[4][x];
        }
        return seqScore / maxScore;
    }

    public static enum ElementType {
        SHINE_DALGARNO,
        GTAG_INTRON_SPLICE_ACCEPTOR,
        GCAG_INTRON_SPLICE_ACCEPTOR,
        GTAG_INTRON_SPLICE_DONOR,
        GCAG_INTRON_SPLICE_DONOR,
        KOZAK_SIGNAL,
        PROK_PROMOTER_35,
        PROK_PROMOTER_10,
        CAP_BINDING_SITE,
        MEF_BINDING_SITE;

    }
}

