/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.DNAAnalyzer;
import DNAAnalyzer.ScoringMatrix;

public class SimpleMatrixAnalyzer
extends DNAAnalyzer {
    public static final SimpleMatrixAnalyzer GT_INTRON_SD = new SimpleMatrixAnalyzer(ScoringMatrix.Matrix_GTSD, "GT/AG Intron Splice Donor");
    public static final SimpleMatrixAnalyzer GT_INTRON_SA = new SimpleMatrixAnalyzer(ScoringMatrix.Matrix_GTSA, "GT/AG Intron Splice Acceptor");
    public static final SimpleMatrixAnalyzer GC_INTRON_SD = new SimpleMatrixAnalyzer(ScoringMatrix.Matrix_GCSD, "GC/AG Intron Splice Donor");
    public static final SimpleMatrixAnalyzer GC_INTRON_SA = new SimpleMatrixAnalyzer(ScoringMatrix.Matrix_GCSA, "GC/AG Intron Splice Acceptor");
    public static final SimpleMatrixAnalyzer CAP = new SimpleMatrixAnalyzer(ScoringMatrix.Matrix_CAP, "CAP Binding Site");
    public static final SimpleMatrixAnalyzer MEF = new SimpleMatrixAnalyzer(ScoringMatrix.Matrix_MEF, "MEF Binding Site");

    public SimpleMatrixAnalyzer() {
    }

    public SimpleMatrixAnalyzer(ScoringMatrix matrix) {
        super(matrix);
    }

    public SimpleMatrixAnalyzer(float[][] matrix) {
        super(matrix);
    }

    public SimpleMatrixAnalyzer(ScoringMatrix matrix, String description) {
        super(matrix);
        this.description = description;
    }

    public SimpleMatrixAnalyzer(float[][] matrix, String description) {
        super(matrix);
        this.description = description;
    }

    @Override
    protected boolean analyzeSequence(String seq) {
        char[] sequence = seq.toCharArray();
        this.results.clear();
        int minLength = this.matrix.minLength;
        int first = this.startIndex;
        int last = this.stopIndex;
        if (last == 0) {
            last = sequence.length - minLength;
        }
        for (int x = first; x < last; ++x) {
            float score = this.matrix.score(sequence, x);
            if (!(score >= this.cutoff)) continue;
            AnalyzerResult result = new AnalyzerResult(this.description, score);
            result.sequence = this.matrix.formatSequence(sequence, x);
            result.score = score;
            result.start = x;
            result.stop = x + minLength;
            this.results.add(result);
        }
        return !this.results.isEmpty();
    }
}

