/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.DNAAnalyzer;
import DNAAnalyzer.ScoringMatrix;

public class Sigma70Analyzer
extends DNAAnalyzer {
    private ScoringMatrix matrix10 = ScoringMatrix.Matrix_P10;
    int rangeMax = 19;
    int rangeMin = 15;

    public Sigma70Analyzer() {
        this.matrix = ScoringMatrix.Matrix_P35;
        this.description = "Promoter";
    }

    @Override
    protected boolean analyzeSequence(String sequence) {
        char[] seq = sequence.toCharArray();
        this.results.clear();
        int first = this.startIndex;
        int last = this.stopIndex;
        if (last == 0) {
            last = seq.length;
        }
        int minLength = this.matrix.minLength;
        for (int offset35 = first; offset35 < last; ++offset35) {
            float score35 = this.matrix.score(seq, offset35);
            if (!(score35 >= this.cutoff)) continue;
            int min = offset35 + minLength + this.rangeMin;
            int max = offset35 + minLength + this.rangeMax;
            for (int offset10 = min; offset10 <= max; ++offset10) {
                float score10 = this.matrix10.score(seq, offset10);
                if (!(score10 >= this.cutoff)) continue;
                AnalyzerResult result = new AnalyzerResult(this.description);
                String seq35 = this.matrix.formatSequence(seq, offset35);
                String seq10 = this.matrix10.formatSequence(seq, offset10);
                String seqSpacer = sequence.substring(offset35 + minLength, offset10);
                float scoreSpacer = 0.0f;
                switch (seqSpacer.length()) {
                    case 15: {
                        scoreSpacer = -0.3f;
                        break;
                    }
                    case 16: {
                        scoreSpacer = -0.05f;
                        break;
                    }
                    case 17: {
                        scoreSpacer = 0.5f;
                        break;
                    }
                    case 18: {
                        scoreSpacer = 0.075f;
                        break;
                    }
                    case 19: {
                        scoreSpacer = -0.5f;
                    }
                }
                result.sequence = seq35 + seqSpacer.toLowerCase() + seq10;
                result.score = (score35 + score10) / 2.0f;
                result.start = offset35 + 1;
                result.stop = offset10 + 1 + this.matrix10.minLength;
                result.addProperty("-35 box start", offset35 + 1);
                result.addProperty("-35 sequence", seq35);
                result.addProperty("-35 box score", Float.valueOf(score35));
                result.addProperty("-10 box start", offset10 + 1);
                result.addProperty("-10 sequence", seq10);
                result.addProperty("-10 box score", Float.valueOf(score10));
                result.addProperty("spacer length", seqSpacer.length());
                result.addProperty("spacer sequence", seqSpacer);
                result.addProperty("spacer score", Float.valueOf(scoreSpacer));
                this.results.add(result);
            }
        }
        return !this.results.isEmpty();
    }
}

