/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.DNAAnalyzer;
import DNAAnalyzer.ScoringMatrix;
import ProteinTools.CodonTable;
import Sequences.DNA;

public class ShineDalgarnoAnalyzer
extends DNAAnalyzer {
    public CodonTable codonTable = new CodonTable();
    String startCodon = "ATG";
    int minORF = 0;
    int maxORF = 0;
    int rangeMax = 17;
    int rangeMin = 0;

    public ShineDalgarnoAnalyzer() {
        this.matrix = ScoringMatrix.Matrix_SD;
        this.description = "Shine Dalgarno signal";
    }

    public void setORFMinMax(int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max < 0) {
            max = 0;
        }
        this.minORF = min;
        this.maxORF = max;
    }

    public void setStartCodon(String codon) {
        if ((codon = DNA.filterSequence(codon).toUpperCase()).length() < 3) {
            return;
        }
        this.startCodon = codon;
    }

    @Override
    protected boolean analyzeSequence(String sequence) {
        char[] seq = sequence.toCharArray();
        this.results.clear();
        int minLength = this.matrix.minLength;
        int first = this.startIndex;
        int last = this.stopIndex;
        if (last == 0) {
            last = seq.length;
        }
        int codonIndex = Math.max(minLength, first);
        codonIndex = sequence.indexOf(this.startCodon, codonIndex);
        while (codonIndex != -1 && codonIndex < last) {
            int min = codonIndex - this.rangeMax;
            int max = codonIndex - minLength;
            for (int offset = min; offset <= max; ++offset) {
                float score = this.matrix.score(seq, offset);
                if (!(score >= this.cutoff)) continue;
                String translation = this.codonTable.translate(seq, codonIndex, CodonTable.LetterCode.e1_Letter_Code, true);
                if (!(this.minORF == 0 && this.maxORF == 0 || this.minORF > 0 && this.maxORF > 0 && translation.length() >= this.minORF && translation.length() <= this.maxORF || this.minORF > 0 && this.maxORF == 0 && translation.length() >= this.minORF) && (this.maxORF <= 0 || this.minORF <= 0 || translation.length() > this.maxORF)) continue;
                AnalyzerResult result = new AnalyzerResult(this.description, score);
                result.start = offset + 1;
                result.stop = codonIndex;
                result.sequence = this.matrix.formatSequence(seq, offset) + sequence.substring(offset + minLength, codonIndex).toLowerCase() + this.startCodon;
                result.addProperty("translation", translation);
                this.results.add(result);
            }
            ++codonIndex;
            codonIndex = sequence.indexOf(this.startCodon, codonIndex);
        }
        return !this.results.isEmpty();
    }
}

