/*
 * Decompiled with CFR 0.152.
 */
package DNAAnalyzer;

import DNAAnalyzer.AnalyzerResult;
import DNAAnalyzer.SequenceAnalyzer;
import Sequences.DNA;
import java.util.ArrayList;
import java.util.Arrays;

public class SaRNAFinder
extends SequenceAnalyzer {
    private static final int COL_DG = 0;
    private static final int COL_ERR_DG = 1;
    private static final int COL_DH = 2;
    private static final int COL_ERR_DH = 3;
    private static final int COL_DS = 4;
    private static final int COL_ERR_DS = 5;
    private static final float DEF_CUT_OFF = 0.0f;
    private static final float[][] energyTable = new float[][]{{-0.93f, 0.03f, -6.82f, 0.79f, -19.0f, 2.5f}, {-2.24f, 0.06f, -11.4f, 1.23f, -29.5f, 3.9f}, {-2.08f, 0.06f, -10.48f, 1.24f, -27.1f, 3.8f}, {-1.1f, 0.08f, -9.38f, 1.68f, -26.7f, 5.2f}, {-2.11f, 0.07f, -10.44f, 1.28f, -26.9f, 3.9f}, {-3.26f, 0.07f, -13.39f, 1.24f, -32.7f, 3.8f}, {-2.36f, 0.09f, -10.64f, 1.65f, -26.7f, 5.0f}, {-2.08f, 0.06f, -10.48f, 1.24f, -27.1f, 3.8f}, {-2.35f, 0.06f, -12.44f, 1.2f, -32.5f, 3.7f}, {-3.42f, 0.08f, -14.88f, 1.58f, -36.9f, 4.9f}, {-3.26f, 0.07f, -13.39f, 1.24f, -32.7f, 3.8f}, {-2.24f, 0.06f, -11.4f, 1.23f, -29.5f, 3.9f}, {-1.33f, 0.09f, -7.69f, 2.02f, -20.5f, 6.3f}, {-2.35f, 0.06f, -12.44f, 1.2f, -32.5f, 3.7f}, {-2.11f, 0.07f, -10.44f, 1.28f, -26.9f, 3.9f}, {-0.93f, 0.03f, -6.82f, 0.79f, -19.0f, 2.5f}};
    private static final float[][] perTermTable = new float[][]{{4.09f, 0.22f, 3.61f, 4.12f, -1.5f, 12.7f}, {0.45f, 0.04f, 3.72f, 0.83f, 10.5f, 2.6f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.45f, 0.04f, 3.72f, 0.83f, 10.5f, 2.6f}, {0.43f, 0.0f, 0.0f, 0.0f, -1.4f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}};
    private static final String[] N5 = new String[]{SaRNAFinder.repeat('A', 5), SaRNAFinder.repeat('C', 5), SaRNAFinder.repeat('U', 5), SaRNAFinder.repeat('G', 5)};
    private static final String[] N6 = new String[]{SaRNAFinder.repeat('A', 6), SaRNAFinder.repeat('C', 6), SaRNAFinder.repeat('U', 6), SaRNAFinder.repeat('G', 6)};
    private static final String[] N7 = new String[]{SaRNAFinder.repeat('A', 7), SaRNAFinder.repeat('C', 7), SaRNAFinder.repeat('U', 7), SaRNAFinder.repeat('G', 7)};
    private static final String[] N8 = new String[]{SaRNAFinder.repeat('A', 8), SaRNAFinder.repeat('C', 8), SaRNAFinder.repeat('U', 8), SaRNAFinder.repeat('G', 8)};
    private static final String[] N32 = new String[]{SaRNAFinder.repeat("AC", 3), SaRNAFinder.repeat("AG", 3), SaRNAFinder.repeat("AU", 3), SaRNAFinder.repeat("CA", 3), SaRNAFinder.repeat("CG", 3), SaRNAFinder.repeat("CU", 3), SaRNAFinder.repeat("GA", 3), SaRNAFinder.repeat("GC", 3), SaRNAFinder.repeat("GU", 3), SaRNAFinder.repeat("UA", 3), SaRNAFinder.repeat("UC", 3), SaRNAFinder.repeat("UG", 3)};
    private static final String[] N42 = new String[]{SaRNAFinder.repeat("AC", 4), SaRNAFinder.repeat("AG", 4), SaRNAFinder.repeat("AU", 4), SaRNAFinder.repeat("CA", 4), SaRNAFinder.repeat("CG", 4), SaRNAFinder.repeat("CU", 4), SaRNAFinder.repeat("GA", 4), SaRNAFinder.repeat("GC", 4), SaRNAFinder.repeat("GU", 4), SaRNAFinder.repeat("UA", 4), SaRNAFinder.repeat("UC", 4), SaRNAFinder.repeat("UG", 4)};
    private static final String[] N52 = new String[]{SaRNAFinder.repeat("AC", 5), SaRNAFinder.repeat("AG", 5), SaRNAFinder.repeat("AU", 5), SaRNAFinder.repeat("CA", 5), SaRNAFinder.repeat("CG", 5), SaRNAFinder.repeat("CU", 5), SaRNAFinder.repeat("GA", 5), SaRNAFinder.repeat("GC", 5), SaRNAFinder.repeat("GU", 5), SaRNAFinder.repeat("UA", 5), SaRNAFinder.repeat("UC", 5), SaRNAFinder.repeat("UG", 5)};
    private static final String[] N62 = new String[]{SaRNAFinder.repeat("AC", 6), SaRNAFinder.repeat("AG", 6), SaRNAFinder.repeat("AU", 6), SaRNAFinder.repeat("CA", 6), SaRNAFinder.repeat("CG", 6), SaRNAFinder.repeat("CU", 6), SaRNAFinder.repeat("GA", 6), SaRNAFinder.repeat("GC", 6), SaRNAFinder.repeat("GU", 6), SaRNAFinder.repeat("UA", 6), SaRNAFinder.repeat("UC", 6), SaRNAFinder.repeat("UG", 6)};
    private static final String[] N33 = new String[]{SaRNAFinder.repeat("AAU", 3), SaRNAFinder.repeat("AAC", 3), SaRNAFinder.repeat("AAG", 3), SaRNAFinder.repeat("AUA", 3), SaRNAFinder.repeat("AUU", 3), SaRNAFinder.repeat("AUC", 3), SaRNAFinder.repeat("AUG", 3), SaRNAFinder.repeat("ACA", 3), SaRNAFinder.repeat("ACU", 3), SaRNAFinder.repeat("ACC", 3), SaRNAFinder.repeat("ACG", 3), SaRNAFinder.repeat("AGA", 3), SaRNAFinder.repeat("AGU", 3), SaRNAFinder.repeat("AGC", 3), SaRNAFinder.repeat("AGG", 3), SaRNAFinder.repeat("UAA", 3), SaRNAFinder.repeat("UAU", 3), SaRNAFinder.repeat("UAC", 3), SaRNAFinder.repeat("UAG", 3), SaRNAFinder.repeat("UUA", 3), SaRNAFinder.repeat("UUC", 3), SaRNAFinder.repeat("UUG", 3), SaRNAFinder.repeat("UCA", 3), SaRNAFinder.repeat("UCU", 3), SaRNAFinder.repeat("UCC", 3), SaRNAFinder.repeat("UCG", 3), SaRNAFinder.repeat("UGA", 3), SaRNAFinder.repeat("UGU", 3), SaRNAFinder.repeat("UGC", 3), SaRNAFinder.repeat("UGG", 3), SaRNAFinder.repeat("CAA", 3), SaRNAFinder.repeat("CAU", 3), SaRNAFinder.repeat("CAC", 3), SaRNAFinder.repeat("CAG", 3), SaRNAFinder.repeat("CUA", 3), SaRNAFinder.repeat("CUU", 3), SaRNAFinder.repeat("CUC", 3), SaRNAFinder.repeat("CUG", 3), SaRNAFinder.repeat("CCA", 3), SaRNAFinder.repeat("CCU", 3), SaRNAFinder.repeat("CCG", 3), SaRNAFinder.repeat("CGA", 3), SaRNAFinder.repeat("CGU", 3), SaRNAFinder.repeat("CGC", 3), SaRNAFinder.repeat("CGG", 3), SaRNAFinder.repeat("GAA", 3), SaRNAFinder.repeat("GAU", 3), SaRNAFinder.repeat("GAC", 3), SaRNAFinder.repeat("GAG", 3), SaRNAFinder.repeat("GUA", 3), SaRNAFinder.repeat("GUU", 3), SaRNAFinder.repeat("GUC", 3), SaRNAFinder.repeat("GUG", 3), SaRNAFinder.repeat("GCA", 3), SaRNAFinder.repeat("GCU", 3), SaRNAFinder.repeat("GCC", 3), SaRNAFinder.repeat("GCG", 3), SaRNAFinder.repeat("GGA", 3), SaRNAFinder.repeat("GGU", 3), SaRNAFinder.repeat("GGC", 3)};
    private static final String[] N43 = new String[]{SaRNAFinder.repeat("AAU", 4), SaRNAFinder.repeat("AAC", 4), SaRNAFinder.repeat("AAG", 4), SaRNAFinder.repeat("AUA", 4), SaRNAFinder.repeat("AUU", 4), SaRNAFinder.repeat("AUC", 4), SaRNAFinder.repeat("AUG", 4), SaRNAFinder.repeat("ACA", 4), SaRNAFinder.repeat("ACU", 4), SaRNAFinder.repeat("ACC", 4), SaRNAFinder.repeat("ACG", 4), SaRNAFinder.repeat("AGA", 4), SaRNAFinder.repeat("AGU", 4), SaRNAFinder.repeat("AGC", 4), SaRNAFinder.repeat("AGG", 4), SaRNAFinder.repeat("UAA", 4), SaRNAFinder.repeat("UAU", 4), SaRNAFinder.repeat("UAC", 4), SaRNAFinder.repeat("UAG", 4), SaRNAFinder.repeat("UUA", 4), SaRNAFinder.repeat("UUC", 4), SaRNAFinder.repeat("UUG", 4), SaRNAFinder.repeat("UCA", 4), SaRNAFinder.repeat("UCU", 4), SaRNAFinder.repeat("UCC", 4), SaRNAFinder.repeat("UCG", 4), SaRNAFinder.repeat("UGA", 4), SaRNAFinder.repeat("UGU", 4), SaRNAFinder.repeat("UGC", 4), SaRNAFinder.repeat("UGG", 4), SaRNAFinder.repeat("CAA", 4), SaRNAFinder.repeat("CAU", 4), SaRNAFinder.repeat("CAC", 4), SaRNAFinder.repeat("CAG", 4), SaRNAFinder.repeat("CUA", 4), SaRNAFinder.repeat("CUU", 4), SaRNAFinder.repeat("CUC", 4), SaRNAFinder.repeat("CUG", 4), SaRNAFinder.repeat("CCA", 4), SaRNAFinder.repeat("CCU", 4), SaRNAFinder.repeat("CCG", 4), SaRNAFinder.repeat("CGA", 4), SaRNAFinder.repeat("CGU", 4), SaRNAFinder.repeat("CGC", 4), SaRNAFinder.repeat("CGG", 4), SaRNAFinder.repeat("GAA", 4), SaRNAFinder.repeat("GAU", 4), SaRNAFinder.repeat("GAC", 4), SaRNAFinder.repeat("GAG", 4), SaRNAFinder.repeat("GUA", 4), SaRNAFinder.repeat("GUU", 4), SaRNAFinder.repeat("GUC", 4), SaRNAFinder.repeat("GUG", 4), SaRNAFinder.repeat("GCA", 4), SaRNAFinder.repeat("GCU", 4), SaRNAFinder.repeat("GCC", 4), SaRNAFinder.repeat("GCG", 4), SaRNAFinder.repeat("GGA", 4), SaRNAFinder.repeat("GGU", 4), SaRNAFinder.repeat("GGC", 4)};
    private static final String[] N53 = new String[]{SaRNAFinder.repeat("AAU", 5), SaRNAFinder.repeat("AAC", 5), SaRNAFinder.repeat("AAG", 5), SaRNAFinder.repeat("AUA", 5), SaRNAFinder.repeat("AUU", 5), SaRNAFinder.repeat("AUC", 5), SaRNAFinder.repeat("AUG", 5), SaRNAFinder.repeat("ACA", 5), SaRNAFinder.repeat("ACU", 5), SaRNAFinder.repeat("ACC", 5), SaRNAFinder.repeat("ACG", 5), SaRNAFinder.repeat("AGA", 5), SaRNAFinder.repeat("AGU", 5), SaRNAFinder.repeat("AGC", 5), SaRNAFinder.repeat("AGG", 5), SaRNAFinder.repeat("UAA", 5), SaRNAFinder.repeat("UAU", 5), SaRNAFinder.repeat("UAC", 5), SaRNAFinder.repeat("UAG", 5), SaRNAFinder.repeat("UUA", 5), SaRNAFinder.repeat("UUC", 5), SaRNAFinder.repeat("UUG", 5), SaRNAFinder.repeat("UCA", 5), SaRNAFinder.repeat("UCU", 5), SaRNAFinder.repeat("UCC", 5), SaRNAFinder.repeat("UCG", 5), SaRNAFinder.repeat("UGA", 5), SaRNAFinder.repeat("UGU", 5), SaRNAFinder.repeat("UGC", 5), SaRNAFinder.repeat("UGG", 5), SaRNAFinder.repeat("CAA", 5), SaRNAFinder.repeat("CAU", 5), SaRNAFinder.repeat("CAC", 5), SaRNAFinder.repeat("CAG", 5), SaRNAFinder.repeat("CUA", 5), SaRNAFinder.repeat("CUU", 5), SaRNAFinder.repeat("CUC", 5), SaRNAFinder.repeat("CUG", 5), SaRNAFinder.repeat("CCA", 5), SaRNAFinder.repeat("CCU", 5), SaRNAFinder.repeat("CCG", 5), SaRNAFinder.repeat("CGA", 5), SaRNAFinder.repeat("CGU", 5), SaRNAFinder.repeat("CGC", 5), SaRNAFinder.repeat("CGG", 5), SaRNAFinder.repeat("GAA", 5), SaRNAFinder.repeat("GAU", 5), SaRNAFinder.repeat("GAC", 5), SaRNAFinder.repeat("GAG", 5), SaRNAFinder.repeat("GUA", 5), SaRNAFinder.repeat("GUU", 5), SaRNAFinder.repeat("GUC", 5), SaRNAFinder.repeat("GUG", 5), SaRNAFinder.repeat("GCA", 5), SaRNAFinder.repeat("GCU", 5), SaRNAFinder.repeat("GCC", 5), SaRNAFinder.repeat("GCG", 5), SaRNAFinder.repeat("GGA", 5), SaRNAFinder.repeat("GGU", 5), SaRNAFinder.repeat("GGC", 5)};
    private static final String[] N63 = new String[]{SaRNAFinder.repeat("AAU", 6), SaRNAFinder.repeat("AAC", 6), SaRNAFinder.repeat("AAG", 6), SaRNAFinder.repeat("AUA", 6), SaRNAFinder.repeat("AUU", 6), SaRNAFinder.repeat("AUC", 6), SaRNAFinder.repeat("AUG", 6), SaRNAFinder.repeat("ACA", 6), SaRNAFinder.repeat("ACU", 6), SaRNAFinder.repeat("ACC", 6), SaRNAFinder.repeat("ACG", 6), SaRNAFinder.repeat("AGA", 6), SaRNAFinder.repeat("AGU", 6), SaRNAFinder.repeat("AGC", 6), SaRNAFinder.repeat("AGG", 6), SaRNAFinder.repeat("UAA", 6), SaRNAFinder.repeat("UAU", 6), SaRNAFinder.repeat("UAC", 6), SaRNAFinder.repeat("UAG", 6), SaRNAFinder.repeat("UUA", 6), SaRNAFinder.repeat("UUC", 6), SaRNAFinder.repeat("UUG", 6), SaRNAFinder.repeat("UCA", 6), SaRNAFinder.repeat("UCU", 6), SaRNAFinder.repeat("UCC", 6), SaRNAFinder.repeat("UCG", 6), SaRNAFinder.repeat("UGA", 6), SaRNAFinder.repeat("UGU", 6), SaRNAFinder.repeat("UGC", 6), SaRNAFinder.repeat("UGG", 6), SaRNAFinder.repeat("CAA", 6), SaRNAFinder.repeat("CAU", 6), SaRNAFinder.repeat("CAC", 6), SaRNAFinder.repeat("CAG", 6), SaRNAFinder.repeat("CUA", 6), SaRNAFinder.repeat("CUU", 6), SaRNAFinder.repeat("CUC", 6), SaRNAFinder.repeat("CUG", 6), SaRNAFinder.repeat("CCA", 6), SaRNAFinder.repeat("CCU", 6), SaRNAFinder.repeat("CCG", 6), SaRNAFinder.repeat("CGA", 6), SaRNAFinder.repeat("CGU", 6), SaRNAFinder.repeat("CGC", 6), SaRNAFinder.repeat("CGG", 6), SaRNAFinder.repeat("GAA", 6), SaRNAFinder.repeat("GAU", 6), SaRNAFinder.repeat("GAC", 6), SaRNAFinder.repeat("GAG", 6), SaRNAFinder.repeat("GUA", 6), SaRNAFinder.repeat("GUU", 6), SaRNAFinder.repeat("GUC", 6), SaRNAFinder.repeat("GUG", 6), SaRNAFinder.repeat("GCA", 6), SaRNAFinder.repeat("GCU", 6), SaRNAFinder.repeat("GCC", 6), SaRNAFinder.repeat("GCG", 6), SaRNAFinder.repeat("GGA", 6), SaRNAFinder.repeat("GGU", 6), SaRNAFinder.repeat("GGC", 6)};

    public SaRNAFinder() {
        this.minCutoff = -10.0f;
        this.maxCutoff = 10.0f;
        this.cutoff = 0.0f;
    }

    public boolean generate(String seq) {
        this.results.clear();
        this.results = SaRNAFinder.find(seq, this.cutoff);
        return this.results.size() > 0;
    }

    public boolean generate(String seq, int tss) {
        this.results.clear();
        this.results = SaRNAFinder.find(seq, this.cutoff, tss);
        return this.results.size() > 0;
    }

    public boolean generate(String seq, float cutoff) {
        this.results.clear();
        this.results = SaRNAFinder.find(seq, cutoff);
        return this.results.size() > 0;
    }

    public boolean generate(String seq, float cutoff, int tss) {
        this.results.clear();
        this.results = SaRNAFinder.find(seq, cutoff, tss);
        return this.results.size() > 0;
    }

    public static ArrayList<AnalyzerResult> find(String seq, float cutoff) {
        return SaRNAFinder.find(seq, cutoff, 0);
    }

    public static ArrayList<AnalyzerResult> find(String seq, int tss) {
        return SaRNAFinder.find(seq, 0.0f, 0);
    }

    public static ArrayList<AnalyzerResult> find(String DNASeq, float cutoff, int tss) {
        String seq = DNA.filterSequence(DNASeq).toUpperCase();
        ArrayList<AnalyzerResult> results = new ArrayList<AnalyzerResult>();
        int limit = seq.length() - 29;
        int start = 0;
        int stop = 0;
        stop = tss > 0 ? tss : seq.length() - tss;
        stop = Math.min(stop, limit);
        for (int x = start; x < stop; ++x) {
            Result r = new Result();
            r.setSequence(seq.substring(x, x + 19));
            r.start = x + 1;
            r.stop = r.start + 18;
            r.AT20_23 = (float)DNA.getATCount(seq.substring(x + 19, x + 23)) / 2.0f;
            if (!(r.getScore() >= cutoff)) continue;
            if (x < 10) {
                r.base_5_10 = seq.substring(0, 10);
                r.base_3_10 = seq.substring(x + 19, x + 29);
            } else if (x > 10 && x < limit) {
                r.base_5_10 = seq.substring(x - 10, x);
                r.base_3_10 = seq.substring(x + 19, x + 29);
            } else {
                r.base_5_10 = seq.substring(x - 10, x);
                r.base_3_10 = seq.substring(x, x + 19);
            }
            r.dTSS = tss < 0 ? x + tss - seq.length() : (tss > 0 ? x - 1 : x + tss);
            AnalyzerResult r2 = new AnalyzerResult();
            r2.score = r.score;
            r2.start = r.start;
            r2.stop = r.stop;
            r2.addProperty("Score", Float.valueOf(r.score));
            r2.addProperty("DNA Sequence", r.DNASeq);
            r2.addProperty("RNA Sequence", r.RNASeq);
            r2.addProperty("RNA (Complementery)", r.RNAComp);
            r2.addProperty("5' 10 bases", r.base_5_10);
            r2.addProperty("3' 10 bases", r.base_3_10);
            r2.addProperty("Start", r.start);
            r2.addProperty("Stop", r.stop);
            r2.addProperty("gcContent", Float.valueOf(r.gc_content));
            r2.addProperty("gc", Float.valueOf(r.gc));
            r2.addProperty("Not5N", Float.valueOf(r.n5));
            r2.addProperty("dG 3' < 5'", Float.valueOf(r.dG35));
            r2.addProperty("A19", Float.valueOf(r.a19));
            r2.addProperty("A/T18", Float.valueOf(r.at18));
            r2.addProperty("T7", Float.valueOf(r.t7));
            r2.addProperty("20_23 A/T", Float.valueOf(r.AT20_23));
            r2.addProperty("in CpG", r.inGCI);
            r2.addProperty("CpG Count", Float.valueOf(r.cpgCount));
            r2.addProperty("CpG Count / 2", Float.valueOf(r.cpg));
            r2.addProperty("4-8 ACTCA/CGTGC", Float.valueOf(r.ACTCA_CGTGC_48));
            r2.addProperty("(NN)3", Float.valueOf(r.nn3));
            r2.addProperty("(NNN)3", Float.valueOf(r.nnn3));
            results.add(r2);
        }
        results.sort(AnalyzerResult.sortScoreHighToLow);
        return results;
    }

    private static void scoreDeltaDG(Result result) {
        String comp = DNA.complementSequence(result.DNASeq);
        float dGterm1 = SaRNAFinder.getTerm(result.RNASeq.charAt(0), 0);
        float dGterm2 = SaRNAFinder.getTerm(result.RNASeq.charAt(result.RNASeq.length() - 1), 0);
        float dG5 = 0.0f;
        for (int x = 0; x < 3; ++x) {
            dG5 += SaRNAFinder.getNN(comp.charAt(x + 1), comp.charAt(x), 0);
        }
        float dG3 = 0.0f;
        for (int x = result.RNASeq.length() - 4; x < result.RNASeq.length() - 1; ++x) {
            dG3 += SaRNAFinder.getNN(comp.charAt(x + 1), comp.charAt(x), 0);
        }
        float ddG = dG5 - dG3 + dGterm1 - dGterm2;
        result.dG35 = ddG < 0.0f ? 1.0f : (ddG > 0.0f ? -1.0f : 0.0f);
    }

    private static void inCpG(Result result) {
        float pctCG = (float)result.RNASeq.replace("A", "").replace("T", "").length() / (float)result.RNASeq.length();
        SaRNAFinder.CpGcount(result);
        float Cnum = result.RNASeq.length() - result.RNASeq.replace("C", "").length();
        float Gnum = result.RNASeq.length() - result.RNASeq.replace("G", "").length();
        float ExpCG = Cnum * Gnum / (float)result.RNASeq.length();
        float OEratio = result.cpgCount / ExpCG;
        result.inGCI = (double)pctCG > 0.5 && (double)OEratio > 0.6;
    }

    private static void CpGcount(Result result) {
        result.cpgCount = 0.0f;
        for (int iNumOfNN = 0; iNumOfNN < result.RNASeq.length() - 1; ++iNumOfNN) {
            if (!result.RNASeq.substring(iNumOfNN, iNumOfNN + 2).equals("CG")) continue;
            result.cpgCount -= 1.0f;
        }
        result.cpg = result.cpgCount / 2.0f;
    }

    private static float getNN(char c1, char c2, int col) {
        int row = 0;
        switch (c1) {
            case 'A': 
            case 'a': {
                break;
            }
            case 'C': 
            case 'c': {
                row = 4;
                break;
            }
            case 'G': 
            case 'g': {
                row = 8;
                break;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                row = 12;
            }
        }
        switch (c2) {
            case 'A': 
            case 'a': {
                break;
            }
            case 'C': 
            case 'c': {
                ++row;
                break;
            }
            case 'G': 
            case 'g': {
                row += 2;
                break;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                row += 3;
            }
        }
        return energyTable[row][col];
    }

    private static float getTerm(char c, int col) {
        switch (c) {
            case 'A': 
            case 'a': {
                return perTermTable[1][col];
            }
            case 'C': 
            case 'c': {
                return perTermTable[2][col];
            }
            case 'G': 
            case 'g': {
                return perTermTable[3][col];
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return perTermTable[4][col];
            }
        }
        return 0.0f;
    }

    private static void scoreRepeats(Result result) {
        String qry = result.RNASeq.toUpperCase();
        result.n5 = 0.0f;
        if (SaRNAFinder.containsSeqs(qry, N8)) {
            result.n5 = -4.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N7)) {
            result.n5 = -2.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N6)) {
            result.n5 = -1.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N5)) {
            result.n5 = -0.5f;
        }
        result.nn3 = 0.0f;
        if (SaRNAFinder.containsSeqs(qry, N62)) {
            result.nn3 = -3.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N52)) {
            result.nn3 = -2.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N42)) {
            result.nn3 = -1.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N32)) {
            result.nn3 = -0.5f;
        }
        result.nnn3 = 0.0f;
        if (SaRNAFinder.containsSeqs(qry, N63)) {
            result.nnn3 = -3.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N53)) {
            result.nnn3 = -2.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N43)) {
            result.nnn3 = -1.0f;
        } else if (SaRNAFinder.containsSeqs(qry, N33)) {
            result.nnn3 = -0.5f;
        }
    }

    private static boolean containsSeqs(String qry, String[] seqs) {
        for (String string : seqs) {
            if (!qry.contains(string)) continue;
            return true;
        }
        return false;
    }

    private static String repeat(char chr, int num) {
        char[] chars = new char[num];
        Arrays.fill(chars, chr);
        return new String(chars);
    }

    private static String repeat(String string, int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return string;
        }
        byte[] value = string.getBytes();
        int coder = 0;
        int len = value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, value[0]);
            return new String(single, coder);
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Repeating " + len + " bytes String " + count + " times will produce a String exceeding maximum size.");
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, coder);
    }

    static class Result {
        private String DNASeq = "";
        private String RNASeq = "";
        private String RNAComp = "";
        String base_5_10 = "";
        String base_3_10 = "";
        int start = 0;
        int stop = 0;
        int dTSS = 0;
        float gc_content = 0.0f;
        float gc = 0.0f;
        float n5 = 0.0f;
        float nn3 = 0.0f;
        float nnn3 = 0.0f;
        float dG35 = 0.0f;
        float ACTCA_CGTGC_48 = 0.0f;
        float t7 = 0.0f;
        float at18 = 0.0f;
        float a19 = 0.0f;
        float AT20_23 = 0.0f;
        boolean inGCI = false;
        float cpg = 0.0f;
        float cpgCount = 0.0f;
        private float score = -99.0f;
        private boolean scored = false;

        Result() {
        }

        public void setSequence(String dnaSeq) {
            this.DNASeq = dnaSeq.toUpperCase();
            this.RNASeq = this.DNASeq.replace('T', 'U');
            this.RNAComp = DNA.getAntisense(this.DNASeq).replace('T', 'U');
        }

        float getScore() {
            if (!this.scored) {
                this.score();
            }
            return this.score;
        }

        void score() {
            this.gc_content = (float)DNA.getGCCount(this.DNASeq) / (float)this.DNASeq.length() * 100.0f;
            this.gc = this.gc_content >= 40.0f && this.gc_content <= 55.0f ? 1.0f : -1.0f;
            SaRNAFinder.scoreRepeats(this);
            SaRNAFinder.scoreDeltaDG(this);
            this.ACTCA_CGTGC_48 = this.RNASeq.indexOf("ACTCA") == 3 || this.RNASeq.indexOf("CGTGC_48") == 3 ? 2.0f : 0.0f;
            this.t7 = this.RNASeq.charAt(6) == 'U' ? 0.5f : 0.0f;
            this.at18 = this.RNASeq.charAt(17) == 'A' || this.RNASeq.charAt(17) == 'U' ? 1.0f : 0.0f;
            this.a19 = this.RNASeq.charAt(18) == 'A' ? 1.0f : 0.0f;
            SaRNAFinder.inCpG(this);
            this.score = this.gc + this.n5 + this.dG35 + this.a19 + this.at18 + this.t7 + this.AT20_23 + (float)(this.inGCI ? -2 : 0) + this.cpg + this.ACTCA_CGTGC_48 + this.nn3 + this.nnn3;
        }
    }
}

