/*
 * Decompiled with CFR 0.152.
 */
package CustomPopupMenus;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuScroller {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;
    private int keepVisibleIndex = -1;
    public static final int TRIGGER_ON_MOUSE_CLICK = 0;
    public static final int TRIGGER_ON_MOUSE_OVER = 1;
    private int scrollTrigger = 1;
    private MouseWheelListener scrollListener = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() < 0) {
                MenuScroller.this.firstIndex -= 1;
            } else {
                MenuScroller.this.firstIndex += 1;
            }
            MenuScroller.this.refreshMenu();
        }
    };

    public int getScrollTrigger() {
        return this.scrollTrigger;
    }

    public void setScrollTrigger(int trigger) {
        if (trigger < 0 || trigger > 1) {
            return;
        }
        this.scrollTrigger = trigger;
    }

    public static MenuScroller setScrollerFor(JMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu) {
        return new MenuScroller(menu);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount) {
        return new MenuScroller(menu, scrollCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount) {
        return new MenuScroller(menu, scrollCount);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount, int interval) {
        return new MenuScroller(menu, scrollCount, interval);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval) {
        return new MenuScroller(menu, scrollCount, interval);
    }

    public static MenuScroller setScrollerFor(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new MenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public static MenuScroller setScrollerFor(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        return new MenuScroller(menu, scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public MenuScroller(JMenu menu) {
        this(menu, 15);
    }

    public MenuScroller(JPopupMenu menu) {
        this(menu, 15);
    }

    public MenuScroller(JMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount) {
        this(menu, scrollCount, 150);
    }

    public MenuScroller(JMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount, int interval) {
        this(menu, scrollCount, interval, 0, 0);
    }

    public MenuScroller(JMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        this(menu.getPopupMenu(), scrollCount, interval, topFixedCount, bottomFixedCount);
    }

    public MenuScroller(JPopupMenu menu, int scrollCount, int interval, int topFixedCount, int bottomFixedCount) {
        if (scrollCount <= 0 || interval <= 0) {
            throw new IllegalArgumentException("scrollCount and interval must be greater than 0");
        }
        if (topFixedCount < 0 || bottomFixedCount < 0) {
            throw new IllegalArgumentException("topFixedCount and bottomFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1);
        this.setScrollCount(scrollCount);
        this.setInterval(interval);
        this.setTopFixedCount(topFixedCount);
        this.setBottomFixedCount(bottomFixedCount);
        this.menu = menu;
        menu.addPopupMenuListener(this.menuListener);
    }

    public MenuScrollItem getMenuScrollUpItem() {
        return this.upItem;
    }

    public MenuScrollItem getMenuScrollDownItem() {
        return this.downItem;
    }

    public int getInterval() {
        return this.interval;
    }

    public final void setInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(interval);
        this.downItem.setInterval(interval);
        this.interval = interval;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public final void setScrollCount(int scrollCount) {
        if (scrollCount <= 0) {
            throw new IllegalArgumentException("scrollCount must be greater than 0");
        }
        this.scrollCount = scrollCount;
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public final void setTopFixedCount(int topFixedCount) {
        this.firstIndex = this.firstIndex <= topFixedCount ? topFixedCount : (this.firstIndex += topFixedCount - this.topFixedCount);
        this.topFixedCount = topFixedCount;
    }

    public int getBottomFixedCount() {
        return this.bottomFixedCount;
    }

    public final void setBottomFixedCount(int bottomFixedCount) {
        this.bottomFixedCount = bottomFixedCount;
    }

    public void keepVisible(JMenuItem item) {
        int index;
        this.keepVisibleIndex = item == null ? -1 : (index = this.menu.getComponentIndex(item));
    }

    public void keepVisible(int index) {
        this.keepVisibleIndex = index;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.menuListener);
            this.menu = null;
        }
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int i;
            this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
            this.firstIndex = Math.min(this.menuItems.length - this.bottomFixedCount - this.scrollCount, this.firstIndex);
            int scrollableCount = this.menuItems.length - (this.bottomFixedCount + this.topFixedCount);
            boolean showScrollers = scrollableCount > this.scrollCount;
            int maxWd = 0;
            for (i = 0; i < this.menuItems.length; ++i) {
                this.menuItems[i].removeMouseWheelListener(this.scrollListener);
                int wd = this.menuItems[i].getPreferredSize().width;
                if (wd <= maxWd) continue;
                maxWd = wd;
            }
            this.menu.removeAll();
            for (i = 0; i < this.topFixedCount; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            if (showScrollers) {
                this.menu.add(this.upItem);
            }
            for (i = this.firstIndex; i < this.scrollCount + this.firstIndex; ++i) {
                this.menu.add(this.menuItems[i]);
                if (!showScrollers) continue;
                this.menuItems[i].addMouseWheelListener(this.scrollListener);
            }
            if (showScrollers) {
                this.menu.add(this.downItem);
            }
            for (i = this.menuItems.length - this.bottomFixedCount; i < this.menuItems.length; ++i) {
                this.menu.add(this.menuItems[i]);
            }
            this.menu.setPreferredSize(new Dimension(maxWd, (int)this.menu.getPreferredSize().getHeight()));
            this.menu.revalidate();
            this.menu.repaint();
        }
    }

    static /* synthetic */ Component[] access$102(MenuScroller x0, Component[] x1) {
        x0.menuItems = x1;
        return x1;
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.setMenuItems();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.restoreMenuItems();
            for (int i = 0; i < MenuScroller.this.menuItems.length; ++i) {
                MenuScroller.this.menuItems[i].removeMouseWheelListener(MenuScroller.this.scrollListener);
            }
            MenuScroller.this.firstIndex = 0;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            MenuScroller.access$102(MenuScroller.this, MenuScroller.this.menu.getComponents());
            if (MenuScroller.this.keepVisibleIndex >= MenuScroller.this.topFixedCount && MenuScroller.this.keepVisibleIndex <= MenuScroller.this.menuItems.length - MenuScroller.this.bottomFixedCount && (MenuScroller.this.keepVisibleIndex > MenuScroller.this.firstIndex + MenuScroller.this.scrollCount || MenuScroller.this.keepVisibleIndex < MenuScroller.this.firstIndex)) {
                MenuScroller.this.firstIndex = Math.min(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex);
                MenuScroller.this.firstIndex = Math.max(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex - MenuScroller.this.scrollCount + 1);
            }
            if (MenuScroller.this.menuItems.length > MenuScroller.this.topFixedCount + MenuScroller.this.scrollCount + MenuScroller.this.bottomFixedCount) {
                MenuScroller.this.refreshMenu();
            }
        }

        private void restoreMenuItems() {
            MenuScroller.this.menu.removeAll();
            for (Component component : MenuScroller.this.menuItems) {
                MenuScroller.this.menu.add(component);
            }
        }
    }

    public class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon icon, int increment) {
            this.setIcon(icon);
            this.setDisabledIcon(icon);
            this.timer = new MenuScrollTimer(increment, MenuScroller.this.interval);
            this.addChangeListener(this);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (MenuScroller.this.scrollTrigger == 0 && !MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(true);
                        MenuScrollItem.this.timer.start();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (MenuScroller.this.scrollTrigger == 0 && MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(false);
                        MenuScrollItem.this.timer.stop();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (MenuScroller.this.scrollTrigger == 1 && !MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(true);
                        MenuScrollItem.this.timer.start();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (MenuScroller.this.scrollTrigger == 1 && MenuScrollItem.this.timer.isRunning()) {
                        MenuScrollItem.this.getModel().setArmed(false);
                        MenuScrollItem.this.timer.stop();
                    }
                }
            });
        }

        public void setInterval(int interval) {
            this.timer.setDelay(interval);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (MenuScroller.this.scrollTrigger == 1) {
                if (this.isArmed() && !this.timer.isRunning()) {
                    this.timer.start();
                }
                if (!this.isArmed() && this.timer.isRunning()) {
                    this.timer.stop();
                }
            }
        }
    }

    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        private MenuIcon(int ... yPoints) {
            this.yPoints = yPoints;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Dimension size = c.getSize();
            Graphics g2 = g.create(size.width / 2 - 5, size.height / 2 - 5, 10, 10);
            g2.setColor(Color.GRAY);
            g2.drawPolygon(this.xPoints, this.yPoints, 3);
            g2.setColor(Color.BLACK);
            g2.fillPolygon(this.xPoints, this.yPoints, 3);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollTimer
    extends Timer {
        public MenuScrollTimer(final int increment, int interval) {
            super(interval, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuScroller.this.firstIndex += increment;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }
}

