/*
 * Decompiled with CFR 0.152.
 */
package CustomListBoxes;

import CustomListBoxes.ProgressList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.swing.ImageIcon;

class ProgressListItem {
    private ProgressList.progressBarType mStyle = ProgressList.progressBarType.progressBarGradient;
    private int iconWidth = 75;
    private int iconHeight = 15;
    private float percentDone;
    private Date date = null;
    private Color textColor = Color.BLACK;
    private Color borderColor = Color.BLACK;
    private Color backColor = Color.WHITE;
    private Color barColor = Color.GREEN;
    private String name = "";
    private ImageIcon progressIcon;

    public String toString() {
        return this.name;
    }

    public boolean hasDate() {
        return this.date != null;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color color) {
        if (!this.backColor.equals(color)) {
            this.backColor = color;
            this.progressIcon = null;
        }
    }

    public Color getProgressTextColor() {
        return this.textColor;
    }

    public void setProgressTextColor(Color color) {
        if (!this.textColor.equals(color)) {
            this.textColor = color;
            this.progressIcon = null;
        }
    }

    public Color getProgressBorderColor() {
        return this.borderColor;
    }

    public void setProgressBorderColor(Color color) {
        if (!this.borderColor.equals(color)) {
            this.borderColor = color;
            this.progressIcon = null;
        }
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconHeight(int ht) {
        this.iconHeight = ht;
        this.progressIcon = null;
    }

    public void setIconWidth(int wd) {
        this.iconWidth = wd;
        this.progressIcon = null;
    }

    public Color getProgressBarColor() {
        return this.barColor;
    }

    public void setProgressBarColor(Color color) {
        if (!this.barColor.equals(color)) {
            this.barColor = color;
            this.progressIcon = null;
        }
    }

    public void setProgressStyle(ProgressList.progressBarType style) {
        this.mStyle = style;
    }

    public ProgressList.progressBarType setProgressStyle() {
        return this.mStyle;
    }

    public ProgressListItem(String name) {
        this.setValues(name, 0.0f);
    }

    public ProgressListItem(String name, float percentDone) {
        this.setValues(name, percentDone);
    }

    public ProgressListItem(String name, float percentDone, Color colorBack, Color colorBar) {
        this.barColor = colorBar;
        this.backColor = colorBack;
        this.setValues(name, percentDone);
    }

    public ProgressListItem(String name, float percentDone, Color colorBack, Color colorBar, Color colorProgText, Color colorProgBorder) {
        this.barColor = colorBar;
        this.backColor = colorBack;
        this.textColor = colorProgText;
        this.borderColor = colorProgBorder;
        this.setValues(name, percentDone);
    }

    private void setValues(String name, float percentDone) {
        this.setPercentDone(percentDone);
        this.name = name;
    }

    public ImageIcon getIcon() {
        if (this.progressIcon == null) {
            this.genIcon();
        }
        return this.progressIcon;
    }

    public float getPercentDone() {
        return this.percentDone;
    }

    public void changePercentDoneBy(float percentChange) {
        this.setPercentDone(this.percentDone + percentChange);
    }

    public void setPercentDone(float percentDone) {
        if (percentDone < 0.0f) {
            percentDone = 0.0f;
        }
        if (percentDone > 1.0f) {
            percentDone = 1.0f;
        }
        if (this.percentDone != percentDone) {
            this.percentDone = percentDone;
            this.progressIcon = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void genIcon() {
        BufferedImage icon = new BufferedImage(this.iconWidth, this.iconHeight, 2);
        Graphics2D g2d = icon.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        String sPercent = String.valueOf((int)(this.percentDone * 100.0f)) + "%";
        FontMetrics fm = g2d.getFontMetrics();
        int textWd = fm.stringWidth(sPercent);
        int textHt = fm.getAscent();
        int barWidth = (int)((float)this.iconWidth * this.percentDone);
        g2d.setClip(0, 0, this.iconWidth, this.iconHeight);
        g2d.setColor(this.backColor);
        g2d.fillRect(0, 0, this.iconWidth, this.iconHeight);
        switch (this.mStyle) {
            case progressBarGradient: {
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.backColor, barWidth, 0.0f, this.barColor, false);
                g2d.setPaint(gradient);
                g2d.fillRect(0, 0, barWidth, this.iconHeight);
                break;
            }
            default: {
                g2d.setColor(this.barColor);
                g2d.fillRect(0, 0, barWidth, this.iconHeight);
            }
        }
        g2d.setColor(this.textColor);
        g2d.drawString(sPercent, (this.iconWidth - textWd) / 2, textHt - (this.iconHeight - textHt) / 2);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(this.borderColor);
        g2d.drawRect(0, 0, this.iconWidth, this.iconHeight);
        this.progressIcon = new ImageIcon(icon);
    }
}

