/*
 * Decompiled with CFR 0.152.
 */
package CustomListBoxes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class ColorListItem {
    private Object dataObject;
    private int iconWidth = 15;
    private int iconHeight = 15;
    private Color borderColor = Color.BLACK;
    private Color iconColor = Color.GREEN;
    private String name = "";
    private ImageIcon colorIcon;

    public String toString() {
        return this.name;
    }

    public Color getIconColor() {
        return this.iconColor;
    }

    public Color getIconBorderColor() {
        return this.borderColor;
    }

    public void setIconBorderColor(Color color) {
        if (color != null && !this.borderColor.equals(color)) {
            this.borderColor = color;
            this.colorIcon = null;
        }
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(Object dataObject) {
        this.dataObject = dataObject;
    }

    public void setIconColor(Color color) {
        if (color != null && !this.iconColor.equals(color)) {
            this.iconColor = color;
            this.colorIcon = null;
        }
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void setIconHeight(int ht) {
        this.iconHeight = ht;
        this.colorIcon = null;
    }

    public void setIconWidth(int wd) {
        this.iconWidth = wd;
        this.colorIcon = null;
    }

    public ColorListItem(String name) {
        this.name = name;
    }

    public ColorListItem(String name, Color iconColor) {
        this.name = name;
        this.iconColor = iconColor;
    }

    public ImageIcon getIcon() {
        if (this.colorIcon == null) {
            this.genIcon();
        }
        return this.colorIcon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void genIcon() {
        BufferedImage icon = new BufferedImage(this.iconWidth, this.iconHeight, 2);
        Graphics2D g2d = icon.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getIconColor());
        g2d.fillRect(0, 0, this.iconWidth, this.iconHeight);
        g2d.setColor(this.borderColor);
        g2d.drawRect(0, 0, this.iconWidth - 1, this.iconHeight - 1);
        this.colorIcon = new ImageIcon(icon);
    }
}

