/*
 * Decompiled with CFR 0.152.
 */
package CustomListBoxes;

import CustomListBoxes.ColorListItem;
import CustomListBoxes.ColorListRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.JavaBean;
import javax.swing.DefaultListModel;
import javax.swing.JList;

@JavaBean(defaultProperty="UIClassID", description="Listbox that displays a colored square as well as the text provided by the user.")
public class ColorList
extends JList {
    private DefaultListModel<ColorListItem> listModel;

    private boolean isValidIndex(int itemIndex) {
        return itemIndex >= 0 && itemIndex <= this.listModel.getSize();
    }

    public void setItemIconColor(int itemIndex, Color iconColor) {
        if (this.isValidIndex(itemIndex) && !this.listModel.getElementAt(itemIndex).getIconColor().equals(iconColor)) {
            this.listModel.getElementAt(itemIndex).setIconColor(iconColor);
            this.refresh();
        }
    }

    public int listCount() {
        return this.listModel.getSize();
    }

    public Color getItemIconColor(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            return this.listModel.getElementAt(itemIndex).getIconColor();
        }
        return Color.WHITE;
    }

    public void refresh() {
        Image bufferimage = this.createImage(this.getWidth(), this.getHeight());
        this.paint(bufferimage.getGraphics());
        Graphics g = this.getGraphics();
        g.drawImage(bufferimage, 0, 0, this);
    }

    public ColorList(DefaultListModel<ColorListItem> newListModel) {
        this.setCellRenderer(new ColorListRenderer());
        this.listModel = newListModel;
        this.setModel(this.listModel);
    }

    public ColorList() {
        this.setCellRenderer(new ColorListRenderer());
        this.listModel = new DefaultListModel();
        this.listModel.addElement(new ColorListItem("Color Test GREEN", Color.GREEN));
        this.listModel.addElement(new ColorListItem("Color Test BLUE", Color.BLUE));
        this.listModel.addElement(new ColorListItem("Color Test RED", Color.RED));
        this.listModel.addElement(new ColorListItem("Color Test ORANGE", Color.ORANGE));
        this.listModel.addElement(new ColorListItem("Color Test RED", Color.RED));
        this.listModel.addElement(new ColorListItem("Color Test CYAN", Color.CYAN));
        this.setModel(this.listModel);
    }

    public void clear() {
        this.listModel.removeAllElements();
    }

    public ColorListItem getItem(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            return this.listModel.getElementAt(itemIndex);
        }
        return null;
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public String getItemText(int index) {
        return this.listModel.getElementAt(index).getName();
    }

    public boolean itemExists(String itemText) {
        for (int x = 0; x < this.listModel.getSize(); ++x) {
            if (!this.listModel.elementAt(x).getName().equalsIgnoreCase(itemText)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String itemName) {
        return this.listModel.contains(itemName);
    }

    public void removeItem(int itemIndex) {
        if (this.isValidIndex(itemIndex)) {
            this.listModel.removeElementAt(itemIndex);
        }
    }

    public void moveItemTo(int itemIndex, int newIndex) {
        if (this.isValidIndex(itemIndex) && this.isValidIndex(newIndex)) {
            ColorListItem tmpItem = this.listModel.remove(itemIndex);
            this.listModel.add(newIndex, tmpItem);
        }
    }

    public int addItem(String text) {
        return this.addItem(text, Color.WHITE);
    }

    public int addItem(String text, Color iconColor) {
        this.listModel.addElement(new ColorListItem(text, iconColor));
        return this.listModel.size() - 1;
    }

    public int addItem(ColorListItem newItem) {
        this.listModel.addElement(newItem);
        return this.listModel.size() - 1;
    }
}

