/*
 * Decompiled with CFR 0.152.
 */
package CustomCheckBox;

import CustomCheckBox.AbstractStatedIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class CheckRadioIcon
extends AbstractStatedIcon {
    public static final int STATE_MOUSEOVER = 1;
    public static final int STATE_MOUSEOUT = 2;
    public static final int STATE_MOUSEDOWN = 4;
    public static final int STATE_DISABLED = 8;
    public static final int STATE_ALL_ENABLED = 16;
    public static final int STATE_ALL = 255;
    private int iconWidth = 14;
    private int iconHeight = 14;
    private StoredColors mouseOutColors = new StoredColors(Color.WHITE, Color.BLACK, Color.GREEN.darker());
    private StoredColors mouseOverColors = new StoredColors(Color.WHITE, Color.BLACK, Color.GREEN.darker().darker());
    private StoredColors mouseDownColors = new StoredColors();
    private StoredColors disabledColors = new StoredColors(Color.DARK_GRAY, Color.DARK_GRAY, Color.LIGHT_GRAY);
    private boolean isRadioStyle = false;
    private boolean isXStyle = false;
    private boolean isCheckStyle = true;

    public void setStyle(ICONSTYLE style) {
        switch (style) {
            case CHECK: {
                this.isRadioStyle = false;
                this.isXStyle = false;
                this.isCheckStyle = true;
            }
            case X: {
                this.isRadioStyle = false;
                this.isXStyle = true;
                this.isCheckStyle = false;
            }
            case RADIO: {
                this.isRadioStyle = true;
                this.isXStyle = false;
                this.isCheckStyle = false;
            }
        }
    }

    public void setBackColor(Color color, int state) {
        if ((state & 1) != 0) {
            this.mouseOverColors.backColor = color;
        }
        if ((state & 4) != 0) {
            this.mouseDownColors.backColor = color;
        }
        if ((state & 8) != 0) {
            this.disabledColors.backColor = color;
        }
        if ((state & 2) != 0) {
            this.mouseOutColors.backColor = color;
        }
    }

    public void setBorderColor(Color color, int state) {
        if ((state & 1) != 0) {
            this.mouseOverColors.borderColor = color;
        }
        if ((state & 4) != 0) {
            this.mouseDownColors.borderColor = color;
        }
        if ((state & 8) != 0) {
            this.disabledColors.borderColor = color;
        }
        if ((state & 2) != 0) {
            this.mouseOutColors.borderColor = color;
        }
    }

    public void setCheckColor(Color color, int state) {
        if ((state & 1) != 0) {
            this.mouseOverColors.checkColor = color;
        }
        if ((state & 4) != 0) {
            this.mouseDownColors.checkColor = color;
        }
        if ((state & 8) != 0) {
            this.disabledColors.checkColor = color;
        }
        if ((state & 2) != 0) {
            this.mouseOutColors.checkColor = color;
        }
    }

    public void setDrawBackColor(boolean draw, int state) {
        if ((state & 1) != 0) {
            this.mouseOverColors.showBackColor = draw;
        }
        if ((state & 4) != 0) {
            this.mouseDownColors.showBackColor = draw;
        }
        if ((state & 8) != 0) {
            this.disabledColors.showBackColor = draw;
        }
        if ((state & 2) != 0) {
            this.mouseOutColors.showBackColor = draw;
        }
    }

    public void setDrawBorder(boolean draw, int state) {
        if ((state & 1) != 0) {
            this.mouseOverColors.showBorder = draw;
        }
        if ((state & 4) != 0) {
            this.mouseDownColors.showBorder = draw;
        }
        if ((state & 8) != 0) {
            this.disabledColors.showBorder = draw;
        }
        if ((state & 2) != 0) {
            this.mouseOutColors.showBorder = draw;
        }
    }

    public void setProperties(Color backColor, Color borderColor, Color checkColor, boolean drawBackColor, boolean drawBorder, int state) {
        this.setBackColor(backColor, state);
        this.setBorderColor(borderColor, state);
        this.setCheckColor(checkColor, state);
        this.setDrawBackColor(drawBackColor, state);
        this.setDrawBorder(drawBorder, state);
    }

    public void setProperties(Color backColor, Color borderColor, Color checkColor, int state) {
        this.setBackColor(backColor, state);
        this.setBorderColor(borderColor, state);
        this.setCheckColor(checkColor, state);
    }

    @Override
    public void drawIcon(Component c, Graphics2D g2d, int x, int y, int width, int height, boolean isEnabled, boolean mouseOver, boolean mouseDown, boolean isSelected) {
        StoredColors colors;
        boolean drawCheck = isSelected;
        if (!isEnabled) {
            colors = this.disabledColors;
        } else if (mouseDown) {
            colors = this.mouseDownColors;
        } else if (mouseOver) {
            colors = this.mouseOverColors;
            drawCheck = true;
        } else {
            colors = this.mouseOutColors;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isRadioStyle) {
            if (colors.showBackColor) {
                g2d.setColor(colors.backColor);
                g2d.fillOval(x, y, this.iconWidth, this.iconHeight);
            }
            if (colors.showBorder) {
                g2d.setColor(colors.borderColor);
                g2d.drawOval(x, y, this.iconWidth, this.iconHeight);
            }
            if (drawCheck) {
                g2d.setColor(colors.checkColor);
                g2d.setStroke(new BasicStroke(3.0f));
                g2d.fillOval(x + 3, y + 3, this.iconWidth - 5, this.iconHeight - 5);
            }
        } else {
            Rectangle prevClipRect = g2d.getClipBounds();
            Rectangle clipRect = new Rectangle();
            Rectangle.intersect(prevClipRect, new Rectangle(x, y - 1, this.iconWidth, this.iconHeight), clipRect);
            g2d.setClip(clipRect);
            if (colors.showBackColor) {
                g2d.setColor(colors.backColor);
                g2d.fillRect(x, y - 1, this.iconWidth, this.iconHeight);
            }
            if (drawCheck) {
                g2d.setColor(colors.checkColor);
                g2d.setStroke(new BasicStroke(3.0f));
                if (this.isXStyle) {
                    g2d.drawLine(x, y - 1, x + this.iconWidth, y - 1 + this.iconHeight);
                    g2d.drawLine(x, y - 1 + this.iconHeight, x + this.iconWidth, y - 1);
                } else if (this.isCheckStyle) {
                    g2d.drawLine(x + 4, y + 6, x + 6, y + 8);
                    g2d.drawLine(x + 6, y + 8, x + 10, y + 4);
                }
            }
            g2d.setClip(prevClipRect);
            if (colors.showBorder) {
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.setColor(colors.backColor);
                g2d.drawRect(x + 1, y, this.iconWidth - 2, this.iconHeight - 2);
                g2d.setColor(colors.borderColor);
                g2d.drawRect(x, y - 1, this.iconWidth, this.iconHeight);
            }
        }
    }

    @Override
    public void setIconWidth(int width) {
        super.setIconWidth(width);
        this.iconWidth = width;
    }

    @Override
    public void setIconHeight(int height) {
        super.setIconHeight(height);
        this.iconHeight = height;
    }

    public static enum ICONSTYLE {
        CHECK,
        X,
        RADIO;

    }

    private class StoredColors {
        boolean showBorder = true;
        boolean showBackColor = true;
        Color backColor = Color.WHITE;
        Color borderColor = Color.BLACK;
        Color checkColor = Color.GREEN.darker().darker();

        public StoredColors() {
        }

        public StoredColors(Color backColor, Color borderColor, Color checkColor) {
            this.backColor = backColor;
            this.borderColor = borderColor;
            this.checkColor = checkColor;
        }

        public StoredColors(Color backColor, Color borderColor, Color checkColor, boolean showBackColor, boolean showBorder) {
            this.backColor = backColor;
            this.borderColor = borderColor;
            this.checkColor = checkColor;
            this.showBackColor = showBackColor;
            this.showBorder = showBorder;
        }
    }
}

