/*
 * Decompiled with CFR 0.152.
 */
package CustomCheckBox;

import CustomCheckBox.AbstractStatedIcon;
import java.awt.Component;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ButtonStatedIcon
extends AbstractStatedIcon {
    private final StorageClass mouseOutIcon = new StorageClass();
    private final StorageClass mouseOverIcon = new StorageClass();
    private final StorageClass mouseDownIcon = new StorageClass();
    private final StorageClass disabledIcon = new StorageClass();
    private final StorageClass disabledSelectedIcon = new StorageClass();

    public void setIcon(Icon icon, int state) {
        if ((state & 1) != 0) {
            this.mouseOverIcon.icon = icon;
        }
        if ((state & 4) != 0) {
            this.mouseDownIcon.icon = icon;
        }
        if ((state & 8) != 0) {
            this.disabledIcon.icon = icon;
        }
        if ((state & 0x20) != 0) {
            this.disabledSelectedIcon.icon = icon;
        }
        if ((state & 2) != 0) {
            this.mouseOutIcon.icon = icon;
        }
        this.updateIconSize();
    }

    public Icon getIcon(int state) {
        switch (state) {
            case 1: {
                return this.mouseOverIcon.icon == null ? this.mouseOutIcon.icon : this.mouseOverIcon.icon;
            }
            case 4: {
                return this.mouseDownIcon.icon == null ? this.mouseOutIcon.icon : this.mouseDownIcon.icon;
            }
            case 8: {
                return this.disabledIcon.icon == null ? this.mouseOutIcon.icon : this.disabledIcon.icon;
            }
            case 32: {
                return this.disabledSelectedIcon.icon == null ? this.mouseOutIcon.icon : this.disabledSelectedIcon.icon;
            }
            case 2: {
                return this.mouseOutIcon.icon;
            }
        }
        return null;
    }

    public boolean hasIcon(int state) {
        switch (state) {
            case 1: {
                return this.mouseOverIcon.icon != null || this.mouseOutIcon.icon != null;
            }
            case 4: {
                return this.mouseDownIcon.icon != null || this.mouseOutIcon.icon != null;
            }
            case 8: {
                return this.disabledIcon.icon != null || this.mouseOutIcon.icon != null;
            }
            case 32: {
                return this.disabledSelectedIcon.icon != null || this.mouseOutIcon.icon != null;
            }
            case 2: {
                return this.mouseOutIcon.icon != null || this.mouseOutIcon.icon != null;
            }
        }
        return false;
    }

    private void updateIconSize() {
        this.iconWidth = 0;
        this.iconHeight = 0;
        if (this.mouseOverIcon.icon != null) {
            if (this.iconWidth < this.mouseOverIcon.icon.getIconWidth()) {
                this.iconWidth = this.mouseOverIcon.icon.getIconWidth();
            }
            if (this.iconHeight < this.mouseOverIcon.icon.getIconHeight()) {
                this.iconHeight = this.mouseOverIcon.icon.getIconHeight();
            }
        }
        if (this.mouseDownIcon.icon != null) {
            if (this.iconWidth < this.mouseDownIcon.icon.getIconWidth()) {
                this.iconWidth = this.mouseDownIcon.icon.getIconWidth();
            }
            if (this.iconHeight < this.mouseDownIcon.icon.getIconHeight()) {
                this.iconHeight = this.mouseDownIcon.icon.getIconHeight();
            }
        }
        if (this.mouseOutIcon.icon != null) {
            if (this.iconWidth < this.mouseOutIcon.icon.getIconWidth()) {
                this.iconWidth = this.mouseOutIcon.icon.getIconWidth();
            }
            if (this.iconHeight < this.mouseOutIcon.icon.getIconHeight()) {
                this.iconHeight = this.mouseOutIcon.icon.getIconHeight();
            }
        }
        if (this.disabledIcon.icon != null) {
            if (this.iconWidth < this.disabledIcon.icon.getIconWidth()) {
                this.iconWidth = this.disabledIcon.icon.getIconWidth();
            }
            if (this.iconHeight < this.disabledIcon.icon.getIconHeight()) {
                this.iconHeight = this.disabledIcon.icon.getIconHeight();
            }
        }
        if (this.disabledSelectedIcon.icon != null) {
            if (this.iconWidth < this.disabledSelectedIcon.icon.getIconWidth()) {
                this.iconWidth = this.disabledSelectedIcon.icon.getIconWidth();
            }
            if (this.iconHeight < this.disabledSelectedIcon.icon.getIconHeight()) {
                this.iconHeight = this.disabledSelectedIcon.icon.getIconHeight();
            }
        }
        if (this.mouseOverIcon.icon != null) {
            this.mouseOverIcon.offsetX = (this.iconWidth - this.mouseOverIcon.icon.getIconWidth()) / 2;
            this.mouseOverIcon.offsetY = (this.iconHeight - this.mouseOverIcon.icon.getIconHeight()) / 2;
        }
        if (this.mouseDownIcon.icon != null) {
            this.mouseDownIcon.offsetX = (this.iconWidth - this.mouseDownIcon.icon.getIconWidth()) / 2;
            this.mouseDownIcon.offsetY = (this.iconHeight - this.mouseDownIcon.icon.getIconHeight()) / 2;
        }
        if (this.mouseOutIcon.icon != null) {
            this.mouseOutIcon.offsetX = (this.iconWidth - this.mouseOutIcon.icon.getIconWidth()) / 2;
            this.mouseOutIcon.offsetY = (this.iconHeight - this.mouseOutIcon.icon.getIconHeight()) / 2;
        }
        if (this.disabledIcon.icon != null) {
            this.disabledIcon.offsetX = (this.iconWidth - this.disabledIcon.icon.getIconWidth()) / 2;
            this.disabledIcon.offsetY = (this.iconHeight - this.disabledIcon.icon.getIconHeight()) / 2;
        }
        if (this.disabledSelectedIcon.icon != null) {
            this.disabledSelectedIcon.offsetX = (this.iconWidth - this.disabledSelectedIcon.icon.getIconWidth()) / 2;
            this.disabledSelectedIcon.offsetY = (this.iconHeight - this.disabledSelectedIcon.icon.getIconHeight()) / 2;
        }
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public void drawIcon(Component c, Graphics2D g2d, int x, int y, int width, int height, boolean isEnabled, boolean isMouseOver, boolean isMouseDown, boolean isSelected) {
        if (!isEnabled && isSelected && this.disabledSelectedIcon.icon != null) {
            this.disabledSelectedIcon.icon.paintIcon(c, g2d, this.disabledSelectedIcon.offsetX + x, this.disabledSelectedIcon.offsetY + y);
        } else if (!isEnabled && this.disabledIcon.icon != null) {
            this.disabledIcon.icon.paintIcon(c, g2d, this.disabledIcon.offsetX + x, this.disabledIcon.offsetY + y);
        } else if (isMouseDown && this.mouseDownIcon.icon != null) {
            this.mouseDownIcon.icon.paintIcon(c, g2d, this.mouseDownIcon.offsetX + x, this.mouseDownIcon.offsetY + y);
        } else if (isMouseOver && this.mouseOverIcon.icon != null) {
            this.mouseOverIcon.icon.paintIcon(c, g2d, this.mouseOverIcon.offsetX + x, this.mouseOverIcon.offsetY + y);
        } else if (this.mouseOutIcon.icon != null) {
            this.mouseOutIcon.icon.paintIcon(c, g2d, this.mouseOutIcon.offsetX + x, this.mouseOutIcon.offsetY + y);
        }
    }

    @Override
    public void setIconWidth(int width) {
        super.setIconWidth(width);
        this.iconWidth = width;
    }

    @Override
    public void setIconHeight(int height) {
        super.setIconHeight(height);
        this.iconHeight = height;
    }

    private class StorageClass {
        Icon icon = null;
        int offsetX = 0;
        int offsetY = 0;

        private StorageClass() {
        }
    }
}

