/*
 * Decompiled with CFR 0.152.
 */
package Clipboards;

import Clipboards.ClipBoard;
import Sequences.DNA;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.text.JTextComponent;

public class CopyPasteKeyListener
implements KeyListener {
    private final JTextComponent callingObject;
    private boolean doCopy = true;
    private boolean doCut = true;
    private boolean doPaste = true;

    public CopyPasteKeyListener(JTextComponent callingObject) {
        this.callingObject = callingObject;
    }

    private void setAllowed(AllowedActions allowActions) {
        switch (allowActions) {
            case CUTONLY: {
                this.doCopy = false;
                this.doCut = true;
                this.doPaste = false;
                break;
            }
            case COPYONLY: {
                this.doCopy = true;
                this.doCut = false;
                this.doPaste = false;
                break;
            }
            case PASTEONLY: {
                this.doCopy = false;
                this.doCut = false;
                this.doPaste = true;
                break;
            }
            case COPYCUT: {
                this.doCopy = true;
                this.doCut = true;
                this.doPaste = false;
                break;
            }
            case COPYPASTE: {
                this.doCopy = true;
                this.doCut = false;
                this.doPaste = true;
                break;
            }
            case CUTPASTE: {
                this.doCopy = false;
                this.doCut = true;
                this.doPaste = true;
                break;
            }
            case COPYCUTPASTE: {
                this.doCopy = true;
                this.doCut = true;
                this.doPaste = true;
            }
        }
    }

    public CopyPasteKeyListener(JTextComponent callingObject, AllowedActions allowActions) {
        this.callingObject = callingObject;
        this.setAllowed(allowActions);
    }

    public CopyPasteKeyListener(JTextComponent callingObject, boolean allowCopy, boolean allowCut, boolean allowPaste) {
        this.callingObject = callingObject;
        this.doCopy = allowCopy;
        this.doCut = allowCut;
        this.doPaste = allowPaste;
    }

    public void setAllowCopy(boolean allowCopy) {
        this.doCopy = allowCopy;
    }

    public void setAllowpaste(boolean allowPaste) {
        this.doPaste = allowPaste;
    }

    public void setAllowCut(boolean allowCut) {
        this.doCut = allowCut;
    }

    public boolean getAllowCopy() {
        return this.doCopy;
    }

    public boolean getAllowPaste() {
        return this.doPaste;
    }

    public boolean getAllowCut() {
        return this.doCut;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.callingObject == null) {
            return;
        }
        switch (e.getKeyCode()) {
            case 86: {
                if (!this.doPaste) {
                    return;
                }
                if (!e.isControlDown() && !e.isMetaDown()) break;
                String data = ClipBoard.getText();
                this.callingObject.replaceSelection(DNA.filterSequence(data));
                e.consume();
                break;
            }
            case 67: {
                if (!this.doCopy) {
                    return;
                }
                if (!e.isControlDown() && !e.isMetaDown()) break;
                ClipBoard.setText(this.callingObject.getSelectedText());
                e.consume();
                break;
            }
            case 88: {
                if (!this.doCut) {
                    return;
                }
                if (!e.isControlDown() && !e.isMetaDown()) break;
                if (this.callingObject.getSelectedText() != null) {
                    ClipBoard.setText(this.callingObject.getSelectedText());
                    this.callingObject.replaceSelection("");
                }
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public static enum AllowedActions {
        COPYONLY,
        CUTONLY,
        PASTEONLY,
        COPYCUT,
        COPYPASTE,
        CUTPASTE,
        COPYCUTPASTE;

    }
}

