/*
 * Decompiled with CFR 0.152.
 */
package Chromatograms;

import Chromatograms.Chromatogram;
import JMConstants.Constants;
import JMScrollBars.JMSlider;
import Sequences.DNA;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class ChromatPanel
extends JPanel {
    private JScrollBar scrollBar;
    Chromatogram sense;
    Chromatogram asense;
    ChromatogramViewer viewer = new ChromatogramViewer();

    public void TogglePeaksA() {
        this.viewer.showA = !this.viewer.showA;
        this.repaint();
    }

    public void TogglePeaksC() {
        this.viewer.showC = !this.viewer.showC;
        this.repaint();
    }

    public void TogglePeaksT() {
        this.viewer.showT = !this.viewer.showT;
        this.repaint();
    }

    public void TogglePeaksG() {
        this.viewer.showG = !this.viewer.showG;
        this.repaint();
    }

    public void scrollToStart() {
        this.scrollBar.setValue(0);
    }

    public void scrollToEnd() {
        this.scrollBar.setValue(this.scrollBar.getMaximum());
    }

    public void scrollRight() {
        this.scrollBar.setValue(this.scrollBar.getValue() + this.viewer.getWidth() * 3 / 4);
    }

    public void scrollLeft() {
        this.scrollBar.setValue(this.scrollBar.getValue() - this.viewer.getWidth() * 3 / 4);
    }

    public void setChromatogram(Chromatogram c) {
        this.sense = c;
        this.asense = this.viewer.getReverseChromat(c);
        this.viewer.setChromatogram(this.sense);
        this.updateScrollbar();
    }

    public ChromatPanel() {
        MouseWheelListener mw = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getUnitsToScroll() < 0) {
                    ChromatPanel.this.scrollBar.setValue(ChromatPanel.this.scrollBar.getValue() - ChromatPanel.this.viewer.getWidth() / 4);
                } else {
                    ChromatPanel.this.scrollBar.setValue(ChromatPanel.this.scrollBar.getValue() + ChromatPanel.this.viewer.getWidth() / 4);
                }
            }
        };
        this.addMouseWheelListener(mw);
        MouseWheelListener mwh = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JMSlider src = (JMSlider)e.getSource();
                src.setValue(src.getValue() + (long)e.getUnitsToScroll());
            }
        };
        MouseWheelListener mwv = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JMSlider src = (JMSlider)e.getSource();
                src.setValue(src.getValue() - (long)e.getUnitsToScroll());
            }
        };
        JMSlider vSlider = new JMSlider();
        vSlider.setMinimum(10L);
        vSlider.setMaximum(500L);
        vSlider.setValue(100);
        vSlider.setPreferredSize(new Dimension(22, 50));
        vSlider.setOrientation(1);
        vSlider.setRounded(true);
        vSlider.setThumbShape(3);
        vSlider.setTrackStyle(Constants.DEFAULTRENDERERS.Solid);
        vSlider.addActionListener(e -> this.viewer.setVerticalScale((double)vSlider.getValue() / 100.0));
        vSlider.addMouseWheelListener(mwv);
        JMSlider hSlider = new JMSlider();
        hSlider.setMinimum(10L);
        hSlider.setMaximum(1000L);
        hSlider.setValue(100);
        hSlider.setOrientation(0);
        hSlider.setRounded(true);
        hSlider.setThumbShape(3);
        hSlider.setTrackStyle(Constants.DEFAULTRENDERERS.Solid);
        hSlider.setPreferredSize(new Dimension(22, 22));
        hSlider.addActionListener(e -> {
            this.viewer.setHorizontalScale((double)hSlider.getValue() / 100.0);
            JScrollBar scrollBar = (JScrollBar)SwingUtilities.getAncestorOfClass(JScrollBar.class, hSlider);
            if (scrollBar != null) {
                int maxScroll = this.viewer.getMaxScrollOffset(this.viewer.getWidth());
                scrollBar.setMaximum(maxScroll + scrollBar.getVisibleAmount());
                scrollBar.setEnabled(maxScroll > 0);
            }
        });
        hSlider.addMouseWheelListener(mwh);
        JPanel topPanel = new JPanel();
        topPanel.setOpaque(false);
        topPanel.setLayout(new FlowLayout(0));
        JTextField searchField = new JTextField(8);
        JButton searchBtn = new JButton("Search");
        JButton antisenseBtn = new JButton("Antisense");
        JButton copyBtn = new JButton("Copy");
        JLabel lblFind = new JLabel("Find:");
        topPanel.add(lblFind);
        topPanel.add(searchField);
        topPanel.add(searchBtn);
        topPanel.add(antisenseBtn);
        searchBtn.addActionListener(e -> this.viewer.searchBase(searchField.getText()));
        searchField.addActionListener(e -> this.viewer.searchBase(searchField.getText()));
        antisenseBtn.addActionListener(e -> this.viewer.toggleAntisense());
        copyBtn.addActionListener(e -> this.viewer.copySelectedSequence());
        this.scrollBar = new JScrollBar(0, 0, 1, 0, 1);
        this.scrollBar.addAdjustmentListener(e -> this.viewer.setScrollOffset(this.scrollBar.getValue()));
        this.scrollBar.addMouseWheelListener(mw);
        this.viewer.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ChromatPanel.this.updateScrollbar();
            }
        });
        hSlider.addActionListener(e -> this.updateScrollbar());
        GroupLayout topPanelLayout = new GroupLayout(topPanel);
        topPanel.setLayout(topPanelLayout);
        topPanelLayout.setHorizontalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addContainerGap().addComponent(lblFind).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(searchField, -1, 248, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(searchBtn).addGap(99, 99, 99).addComponent(antisenseBtn).addGap(0, 0, 0)));
        topPanelLayout.setVerticalGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(searchField, -2, 23, -2).addComponent(searchBtn)).addGroup(topPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblFind).addComponent(antisenseBtn))).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout viewerLayout = new GroupLayout(this.viewer);
        this.viewer.setLayout(viewerLayout);
        viewerLayout.setHorizontalGroup(viewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        viewerLayout.setVerticalGroup(viewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(topPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(vSlider, -2, -1, -2).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewer, -1, -1, Short.MAX_VALUE).addComponent(this.scrollBar, -1, -1, Short.MAX_VALUE).addComponent(hSlider, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(topPanel, -2, -1, -2).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(vSlider, -1, 184, Short.MAX_VALUE).addComponent(this.viewer, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.scrollBar, -2, 18, -2).addGap(0, 0, 0).addComponent(hSlider, -2, -1, -2).addGap(0, 0, 0)));
    }

    public void findNext() {
        this.viewer.findNext();
    }

    public void findPrevious() {
        this.viewer.findPrevious();
    }

    public void setAntisense(boolean b) {
        this.viewer.setAntisense(b);
    }

    public void goToFirstMatch(String seq) {
        this.viewer.goToFirstMatch(seq);
    }

    private void updateScrollbar() {
        int maxScroll = this.viewer.getMaxScrollOffset(this.viewer.getWidth());
        int visible = this.viewer.getWidth();
        int max = maxScroll + visible;
        this.scrollBar.setMaximum(max);
        this.scrollBar.setVisibleAmount(visible);
        this.scrollBar.setEnabled(maxScroll > 0);
        this.scrollBar.setValue(Math.min(this.scrollBar.getValue(), maxScroll));
        this.scrollBar.setBlockIncrement(visible > 0 ? visible * 3 / 4 : 0);
    }

    public void copy() {
        this.viewer.copySelectedSequence();
    }

    public void autoScale() {
        if (this.viewer.chromatogram != null) {
            this.viewer.setVerticalScale(this.viewer.getAutoScaleY());
        }
    }

    class ChromatogramViewer
    extends JPanel
    implements MouseListener {
        private Chromatogram chromatogram;
        boolean showA = true;
        boolean showC = true;
        boolean showT = true;
        boolean showG = true;
        double verticalScale = 1.0;
        double horizontalScale = 1.0;
        private byte[] conf;
        private int wdA = 0;
        private int wdC = 0;
        private int wdT = 0;
        private int wdG = 0;
        private int wdN = 0;
        boolean antisense = false;
        int searchIndex = -1;
        String searchBase = "";
        int scrollOffset = 0;
        public Color colorSearch = new Color(255, 255, 0, 128);
        public Color colorSelect = new Color(51, 153, 255, 80);
        private List<FoundItem> searchHits = new ArrayList<FoundItem>();
        private int selectionStartBase = -1;
        private int selectionEndBase = -1;
        private boolean dragging = false;
        private static final int ALPHA = 30;
        private Color bColor;
        private Font sequenceFont = new Font("Monospaced", 0, 18);
        private Font numbersFont = this.sequenceFont.deriveFont(0, this.sequenceFont.getSize() - 2);
        private int findNextIndex = -1;
        Color colorA = Color.GREEN.darker();
        Color colorC = Color.BLUE;
        Color colorT = Color.RED;
        Color colorG = Color.BLACK;
        Color colorFillA = new Color(0, 128, 0, 64);
        Color colorFillC = new Color(0, 0, 255, 64);
        Color colorFillT = new Color(255, 0, 0, 64);
        Color colorFillG = new Color(0, 0, 0, 64);
        int numY = 0;
        int baseY = 0;
        int confTop = 0;
        int confBot = 0;
        int confMaxHt = 50;

        public ChromatogramViewer(Chromatogram chromatogram) {
            this();
            this.setChromatogram(chromatogram);
        }

        private void loadDefaultColors() {
            this.bColor = UIManager.getColor("MolBioTools.ChromatWindow.background");
            if (this.bColor == null) {
                this.bColor = Color.white;
            }
            this.setBackground(this.bColor);
            Color color = UIManager.getColor("MolBioTools.ChromatWindow.colorA");
            if (color != null) {
                this.colorFillA = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.colorT")) != null) {
                this.colorFillT = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.colorG")) != null) {
                this.colorFillG = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.colorC")) != null) {
                this.colorFillC = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.bordercolorA")) != null) {
                this.colorA = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.bordercolorT")) != null) {
                this.colorT = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.bordercolorG")) != null) {
                this.colorG = color;
            }
            if ((color = UIManager.getColor("MolBioTools.ChromatWindow.bordercolorC")) != null) {
                this.colorC = color;
            }
        }

        void setChromatogram(Chromatogram chromatogram) {
            this.chromatogram = chromatogram;
            int len = chromatogram.conf.length();
            this.conf = new byte[len];
            for (int x = 0; x < len; ++x) {
                this.conf[x] = (byte)chromatogram.conf.charAt(x);
            }
            ChromatPanel.this.autoScale();
            this.repaint();
        }

        public ChromatogramViewer() {
            this.loadDefaultColors();
            Border b = UIManager.getBorder("MolBioTools.ChromatWindow.border");
            if (b == null) {
                b = new LineBorder(Color.black);
            }
            this.setBorder(b);
            this.addMouseListener(this);
            this.setBackground(Color.WHITE);
            this.setFocusable(true);
            MouseAdapter mouse = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ChromatogramViewer.this.chromatogram == null) {
                        return;
                    }
                    int base = ChromatogramViewer.this.xToBaseIndex(e.getX());
                    if (base >= 0 && base < ChromatogramViewer.this.getNumBases()) {
                        if (ChromatogramViewer.this.selectionStartBase >= 0 && (e.isShiftDown() || e.isControlDown())) {
                            ChromatogramViewer.this.selectionEndBase = base;
                            ChromatogramViewer.this.dragging = true;
                        } else {
                            ChromatogramViewer.this.selectionStartBase = base;
                            ChromatogramViewer.this.selectionEndBase = base;
                            ChromatogramViewer.this.dragging = true;
                        }
                        ChromatogramViewer.this.repaint();
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int base;
                    if (ChromatogramViewer.this.dragging && (base = ChromatogramViewer.this.xToBaseIndex(e.getX())) >= 0 && base < ChromatogramViewer.this.getNumBases()) {
                        ChromatogramViewer.this.selectionEndBase = base;
                        ChromatogramViewer.this.repaint();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (ChromatogramViewer.this.chromatogram == null) {
                        return;
                    }
                    int base = ChromatogramViewer.this.xToBaseIndex(e.getX());
                    if (ChromatogramViewer.this.dragging && base >= 0 && base < ChromatogramViewer.this.getNumBases()) {
                        ChromatogramViewer.this.selectionEndBase = base;
                        ChromatogramViewer.this.dragging = false;
                    }
                    ChromatogramViewer.this.repaint();
                }
            };
            this.addMouseListener(mouse);
            this.addMouseMotionListener(mouse);
        }

        public void setSequenceFont(Font font) {
            if (font != null) {
                this.sequenceFont = font;
                this.wdA = 0;
                this.wdC = 0;
                this.wdT = 0;
                this.wdG = 0;
                this.wdN = 0;
                this.repaint();
            }
        }

        public void copySelectedSequence() {
            String selected = this.getSelectedSequence();
            if (selected != null && !selected.isEmpty()) {
                StringSelection stringSelection = new StringSelection(selected);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        }

        public String getSelectedSequence() {
            int end;
            if (this.selectionStartBase == -1 || this.selectionEndBase == -1 || this.chromatogram.sequence == null) {
                return "";
            }
            String sequence = this.chromatogram.sequence;
            int nBases = sequence.length();
            int start = Math.max(0, Math.min(this.selectionStartBase, this.selectionEndBase));
            if (start > (end = Math.min(nBases - 1, Math.max(this.selectionStartBase, this.selectionEndBase)))) {
                return "";
            }
            return sequence.substring(start, end + 1);
        }

        private char complement(char base) {
            switch (Character.toUpperCase(base)) {
                case 'A': {
                    return 'T';
                }
                case 'T': {
                    return 'A';
                }
                case 'C': {
                    return 'G';
                }
                case 'G': {
                    return 'C';
                }
            }
            return base;
        }

        public void setVerticalScale(double scale) {
            this.verticalScale = Math.max(0.1, Math.min(5.0, scale));
            this.repaint();
        }

        public void setHorizontalScale(double scale) {
            this.horizontalScale = Math.max(0.1, Math.min(10.0, scale));
            this.repaint();
        }

        public void toggleAntisense() {
            this.setAntisense(!this.antisense);
        }

        public void setAntisense(boolean b) {
            if (b && ChromatPanel.this.viewer.chromatogram == ChromatPanel.this.sense) {
                ChromatPanel.this.viewer.setChromatogram(ChromatPanel.this.asense);
                this.antisense = true;
                this.repaint();
            } else if (!b && ChromatPanel.this.viewer.chromatogram == ChromatPanel.this.asense) {
                ChromatPanel.this.viewer.setChromatogram(ChromatPanel.this.sense);
                this.antisense = false;
                this.repaint();
            }
        }

        public short[] getCurrentTrace(String base) {
            switch (base.toUpperCase()) {
                case "A": {
                    return this.chromatogram.aTrace;
                }
                case "T": {
                    return this.chromatogram.tTrace;
                }
                case "C": {
                    return this.chromatogram.cTrace;
                }
                case "G": {
                    return this.chromatogram.gTrace;
                }
            }
            return null;
        }

        public void setScrollOffset(int offset) {
            this.scrollOffset = Math.max(0, offset);
            this.repaint();
        }

        public int getMaxScrollOffset(int viewWidth) {
            int totalLength = this.chromatogram != null ? this.chromatogram.aTrace.length : 0;
            int totalWidth = (int)((double)totalLength * this.horizontalScale);
            return Math.max(0, totalWidth - viewWidth);
        }

        public void goToFirstMatch(String seq) {
            String seqU = (seq = DNA.filterSequence(seq)).toUpperCase();
            int idx = this.chromatogram.sequence.indexOf(seqU);
            if (idx > -1) {
                this.selectionStartBase = idx;
                this.selectionEndBase = idx;
                this.goToBase(idx);
            }
        }

        public void searchBase(String base) {
            boolean isRegex;
            this.searchBase = base.trim();
            short[] baseTrace = this.getTraceForBase(this.searchBase);
            this.searchHits.clear();
            this.findNextIndex = -1;
            String seq = this.chromatogram.sequence != null ? this.chromatogram.sequence : "";
            short[] basePos = this.chromatogram.basePos;
            int nBases = Math.min(seq.length(), basePos.length);
            if (seq.length() == 0 || basePos.length == 0 || this.searchBase.length() == 0) {
                this.searchIndex = -1;
                this.repaint();
                return;
            }
            boolean bl = isRegex = this.searchBase.length() > 2 && this.searchBase.startsWith("/") && this.searchBase.endsWith("/");
            if (isRegex) {
                String regex = this.searchBase.substring(1, this.searchBase.length() - 1);
                Pattern pattern = Pattern.compile(regex, 2);
                Matcher matcher = pattern.matcher(seq);
                while (matcher.find()) {
                    int len;
                    int idx = matcher.start();
                    if (idx + (len = matcher.end() - matcher.start()) > nBases) continue;
                    int startIndex = idx;
                    int endIndex = idx + len - 1;
                    this.searchHits.add(new FoundItem(startIndex, endIndex));
                }
                this.searchIndex = -1;
            } else {
                String seqU = seq.toUpperCase();
                String queryU = this.searchBase.toUpperCase();
                if (queryU.length() == 1 && baseTrace != null) {
                    this.searchIndex = -1;
                    for (int i = 0; i < baseTrace.length; ++i) {
                        if (baseTrace[i] <= 0) continue;
                        this.searchIndex = i;
                        break;
                    }
                } else {
                    this.searchIndex = -1;
                }
                int idx = seqU.indexOf(queryU);
                while (idx != -1 && idx + queryU.length() <= nBases) {
                    int startIndex = idx;
                    int endIndex = idx + queryU.length() - 1;
                    this.searchHits.add(new FoundItem(startIndex, endIndex));
                    idx = seqU.indexOf(queryU, idx + 1);
                }
            }
            this.selectionStartBase = -1;
            this.selectionEndBase = -1;
            if (!this.searchHits.isEmpty()) {
                this.findNext();
            }
            this.repaint();
        }

        private void findNext() {
            if (this.searchHits.isEmpty()) {
                return;
            }
            if (this.findNextIndex == this.searchHits.size() - 1) {
                this.findNextIndex = -1;
            }
            ++this.findNextIndex;
            this.goToBase(this.searchHits.get((int)this.findNextIndex).start);
        }

        private void findPrevious() {
            if (this.searchHits.isEmpty()) {
                return;
            }
            if (this.findNextIndex == 0) {
                this.findNextIndex = this.searchHits.size();
            }
            --this.findNextIndex;
            this.goToBase(this.searchHits.get((int)this.findNextIndex).start);
        }

        private void goToBase(int bp) {
            int w;
            int x = this.baseIndexToX(bp);
            if (x > (w = this.getWidth())) {
                x -= w / 2;
            } else if (x < w && x > w / 2) {
                x = w / 2;
            } else if (x < w / 2) {
                x = 0;
            }
            ChromatPanel.this.scrollBar.setValue(x);
        }

        private short[] getTraceForBase(String base) {
            return this.getCurrentTrace(base);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.chromatogram == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            if (this.wdA == 0) {
                int ht;
                FontMetrics fm = g2.getFontMetrics(this.sequenceFont);
                this.numbersFont = this.sequenceFont.deriveFont(0, this.sequenceFont.getSize() - 2);
                this.wdA = fm.charWidth('A');
                this.wdT = fm.charWidth('T');
                this.wdC = fm.charWidth('C');
                this.wdG = fm.charWidth('G');
                this.wdN = fm.charWidth('N');
                this.numY = ht = fm.getAscent();
                this.baseY = this.numY + ht;
                this.confTop = this.baseY + 15;
                this.confBot = this.confTop + this.confMaxHt;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int w = this.getWidth();
            int h = this.getHeight();
            this.paintSearchHighlights(g2, w, h);
            this.paintSelectionHighlight(g2, w, h);
            if (this.showA) {
                this.drawFilledTrace(g2, this.chromatogram.aTrace, this.colorFillA, w, h);
            }
            if (this.showT) {
                this.drawFilledTrace(g2, this.chromatogram.tTrace, this.colorFillT, w, h);
            }
            if (this.showC) {
                this.drawFilledTrace(g2, this.chromatogram.cTrace, this.colorFillC, w, h);
            }
            if (this.showG) {
                this.drawFilledTrace(g2, this.chromatogram.gTrace, this.colorFillG, w, h);
            }
            if (this.showA) {
                this.drawTrace(g2, this.chromatogram.aTrace, this.colorA, w, h, "A");
            }
            if (this.showT) {
                this.drawTrace(g2, this.chromatogram.tTrace, this.colorT, w, h, "T");
            }
            if (this.showC) {
                this.drawTrace(g2, this.chromatogram.cTrace, this.colorC, w, h, "C");
            }
            if (this.showG) {
                this.drawTrace(g2, this.chromatogram.gTrace, this.colorG, w, h, "G");
            }
            if (this.searchIndex >= 0) {
                int x = (int)((double)this.searchIndex * this.horizontalScale) - this.scrollOffset;
                g2.setColor(Color.ORANGE);
                g2.drawLine(x, 0, x, h);
            }
            g2.setColor(this.bColor);
            g2.fillRect(0, 0, w, this.confTop);
            this.drawConfidenceBars(g2, w, h);
            this.drawSequenceLetters(g2, w, h);
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawLine(0, this.confTop + 1, w, this.confTop + 1);
        }

        private void drawConfidenceBars(Graphics2D g2, int w, int h) {
            if (this.chromatogram.conf == null) {
                return;
            }
            short[] positions = this.chromatogram.basePos;
            String sequence = this.chromatogram.sequence != null ? this.chromatogram.sequence : "";
            int nBases = Math.min(Math.min(positions.length, this.conf.length), sequence.length());
            int barWidth = 14;
            for (int i = 0; i < nBases; ++i) {
                short pos = positions[i];
                int x = (int)((double)pos * this.horizontalScale) - this.scrollOffset;
                int confIdx = i;
                int score = this.conf[confIdx] & 0xFF;
                int barHeight = (int)Math.round((double)score / 255.0 * (double)this.confMaxHt);
                int xBox = x - barWidth / 2;
                if (x < 0 || x >= w) continue;
                g2.setColor(new Color(0, 180, 0, 200));
                g2.fillRect(xBox, this.confTop - barHeight, barWidth, barHeight);
                g2.setColor(new Color(0, 120, 0));
                g2.drawRect(xBox, this.confTop - barHeight, barWidth, barHeight);
            }
        }

        private void paintSearchHighlights(Graphics2D g2, int w, int h) {
            if (this.searchHits.isEmpty()) {
                return;
            }
            g2.setColor(this.colorSearch);
            for (int i = 0; i < this.searchHits.size(); ++i) {
                FoundItem f = this.searchHits.get(i);
                this.paintBasePositions(g2, w, h, f.start, f.end);
            }
        }

        private void paintSelectionHighlight(Graphics2D g2, int w, int h) {
            g2.setColor(this.colorSelect);
            this.paintBasePositions(g2, w, h, this.selectionStartBase, this.selectionEndBase);
        }

        private void paintBasePositions(Graphics2D g2, int w, int h, int posIndex1, int posIndex2) {
            if (posIndex1 != -1 && posIndex2 != -1) {
                int x2;
                short[] basePos = this.chromatogram.basePos;
                String sequence = this.chromatogram.sequence != null ? this.chromatogram.sequence : "";
                int nBases = Math.min(sequence.length(), basePos.length);
                int startIdx = Math.max(0, Math.min(posIndex1, posIndex2));
                int endIdx = Math.min(nBases - 1, Math.max(posIndex1, posIndex2));
                int x1 = this.getPasePos(startIdx, -1);
                if (x1 > (x2 = this.getPasePos(endIdx, 1))) {
                    int tmp = x1;
                    x1 = x2;
                    x2 = tmp;
                }
                g2.fillRect(x1, 0, Math.max(1, x2 - x1), h);
            }
        }

        private int getPasePos(int idx, int dir) {
            short pos1 = this.chromatogram.basePos[idx];
            char base1 = this.chromatogram.sequence.charAt(idx);
            int charW1 = this.charWidth(base1);
            return (int)((double)pos1 * this.horizontalScale) - this.scrollOffset + dir * charW1 / 2;
        }

        private int baseIndexToX(int idx) {
            char base1 = this.chromatogram.sequence.charAt(idx);
            return (int)((double)this.chromatogram.basePos[idx] * this.horizontalScale) - this.charWidth(base1) / 2;
        }

        private int charWidth(char base) {
            switch (base) {
                case 'A': {
                    return this.wdA;
                }
                case 'T': {
                    return this.wdT;
                }
                case 'C': {
                    return this.wdC;
                }
                case 'G': {
                    return this.wdG;
                }
            }
            return this.wdN;
        }

        private void drawSequenceLetters(Graphics2D g2, int w, int h) {
            short[] positions = this.chromatogram.basePos;
            String sequence = this.chromatogram.sequence != null ? this.chromatogram.sequence : "";
            int nBases = Math.min(positions.length, sequence.length());
            Font oldFont = g2.getFont();
            g2.setFont(this.sequenceFont);
            g2.setStroke(new BasicStroke(1.0f));
            FontMetrics numFm = g2.getFontMetrics(this.numbersFont);
            for (int i = 0; i < nBases; ++i) {
                int baseNum;
                Color color;
                short pos = positions[i];
                int x = (int)((double)pos * this.horizontalScale) - this.scrollOffset;
                if (x < 0 || x >= w) continue;
                char base = sequence.charAt(i);
                switch (Character.toUpperCase(base)) {
                    case 'A': {
                        color = this.colorA;
                        break;
                    }
                    case 'T': {
                        color = this.colorT;
                        break;
                    }
                    case 'C': {
                        color = this.colorC;
                        break;
                    }
                    case 'G': {
                        color = this.colorG;
                        break;
                    }
                    default: {
                        color = Color.GRAY;
                    }
                }
                g2.setColor(color);
                int charW = this.charWidth(base);
                g2.drawString(String.valueOf(base), x - charW / 2, this.baseY);
                int n = baseNum = this.antisense ? this.chromatogram.sequence.length() - i + 1 : i + 1;
                if (baseNum % 10 != 0) continue;
                String numStr = String.valueOf(baseNum);
                int numW = numFm.stringWidth(numStr);
                g2.drawString(numStr, x - numW / 2, this.numY);
                g2.drawLine(x, this.confTop + 1, x, h);
            }
            g2.setFont(oldFont);
        }

        private void drawFilledTrace(Graphics2D g2, short[] trace, Color color, int w, int h) {
            if (trace == null) {
                return;
            }
            int N = trace.length;
            int[] xPoints = new int[N];
            int[] yPoints = new int[N];
            for (int i = 0; i < N; ++i) {
                int idx = i;
                int x = (int)((double)idx * this.horizontalScale) - this.scrollOffset;
                int y = (int)((double)(h - 1) - (double)trace[idx] * this.verticalScale);
                xPoints[i] = x;
                yPoints[i] = y;
            }
            Polygon poly = new Polygon();
            for (int i = 0; i < N; ++i) {
                if (xPoints[i] < 0 || xPoints[i] > w) continue;
                poly.addPoint(xPoints[i], yPoints[i]);
            }
            if (N > 0) {
                poly.addPoint(xPoints[N - 1], h - 1);
                poly.addPoint(xPoints[0], h - 1);
            }
            g2.setColor(color);
            g2.fillPolygon(poly);
        }

        private void drawTrace(Graphics2D g2, short[] trace, Color color, int w, int h, String base) {
            if (trace == null) {
                return;
            }
            int N = trace.length;
            g2.setColor(color);
            g2.setStroke(new BasicStroke(2.0f));
            int[] xPoints = new int[N];
            int[] yPoints = new int[N];
            for (int idx = 0; idx < N; ++idx) {
                int x = (int)((double)idx * this.horizontalScale) - this.scrollOffset;
                int y = (int)((double)(h - 1) - (double)trace[idx] * this.verticalScale);
                xPoints[idx] = x;
                yPoints[idx] = y;
            }
            for (int i = 1; i < N; ++i) {
                int x1 = xPoints[i - 1];
                int y1 = yPoints[i - 1];
                int x2 = xPoints[i];
                int y2 = yPoints[i];
                if (x1 < 0 || x1 >= w || x2 < 0 || x2 >= w) continue;
                g2.drawLine(x1, y1, x2, y2);
            }
        }

        private int getNumBases() {
            return Math.min(this.chromatogram.sequence.length(), this.chromatogram.basePos.length);
        }

        private int xToBaseIndex(int x) {
            short[] basePos = this.chromatogram.basePos;
            int nBases = this.getNumBases();
            int minDist = Integer.MAX_VALUE;
            int bestIdx = -1;
            for (int i = 0; i < nBases; ++i) {
                short pos = basePos[i];
                int px = (int)((double)pos * this.horizontalScale) - this.scrollOffset;
                int dist = Math.abs(px - x);
                if (dist >= minDist) continue;
                minDist = dist;
                bestIdx = i;
            }
            return minDist < 24 ? bestIdx : -1;
        }

        private void handleMouseSelection(MouseEvent e) {
            if (this.chromatogram == null) {
                return;
            }
            int clickedBase = this.getBaseIndexAtPosition(e.getX());
            if (clickedBase != -1) {
                if (e.isShiftDown() || e.isControlDown()) {
                    if (this.selectionStartBase == -1) {
                        this.selectionStartBase = clickedBase;
                        this.selectionEndBase = clickedBase;
                    } else {
                        this.selectionEndBase = clickedBase;
                    }
                } else {
                    this.selectionStartBase = clickedBase;
                    this.selectionEndBase = clickedBase;
                }
                this.repaint();
            }
        }

        private int getBaseIndexAtPosition(int xPixel) {
            short[] positions = this.chromatogram.basePos;
            String sequence = this.chromatogram.sequence != null ? this.chromatogram.sequence : "";
            int nBases = Math.min(positions.length, sequence.length());
            for (int i = 0; i < nBases; ++i) {
                short pos = positions[i];
                int xBase = (int)((double)pos * this.horizontalScale) - this.scrollOffset;
                char base = sequence.charAt(i);
                int charW = this.charWidth(base);
                int left = xBase - charW / 2;
                int right = xBase + charW / 2;
                if (xPixel < left || xPixel >= right) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleMouseSelection(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public void autoScale() {
            if (this.chromatogram != null) {
                this.setVerticalScale(this.getAutoScaleY());
            }
        }

        private double getAutoScaleY() {
            return (double)(this.getHeight() - this.confTop) / this.getMaxPeak();
        }

        private double getMaxPeak() {
            double maxPeak = 0.0;
            for (int x = 0; x < this.chromatogram.aTrace.length; ++x) {
                if ((double)this.chromatogram.aTrace[x] > maxPeak) {
                    maxPeak = this.chromatogram.aTrace[x];
                }
                if ((double)this.chromatogram.tTrace[x] > maxPeak) {
                    maxPeak = this.chromatogram.tTrace[x];
                }
                if ((double)this.chromatogram.cTrace[x] > maxPeak) {
                    maxPeak = this.chromatogram.cTrace[x];
                }
                if (!((double)this.chromatogram.gTrace[x] > maxPeak)) continue;
                maxPeak = this.chromatogram.gTrace[x];
            }
            return maxPeak;
        }

        private Chromatogram getReverseChromat(Chromatogram c) {
            Chromatogram outC = new Chromatogram();
            outC.basePos = this.reverseArray(c.basePos);
            outC.conf = new StringBuilder(c.conf).reverse().toString();
            outC.sequence = DNA.getAntisense(c.sequence);
            short[] newT = this.reverseArray(c.aTrace);
            short[] newA = this.reverseArray(c.tTrace);
            short[] newG = this.reverseArray(c.cTrace);
            short[] newC = this.reverseArray(c.gTrace);
            outC.aTrace = newA;
            outC.tTrace = newT;
            outC.cTrace = newC;
            outC.gTrace = newG;
            return outC;
        }

        private short[] reverseArray(short[] array) {
            short[] val = new short[array.length];
            int cIndex = array.length - 1;
            for (int x = 0; x < array.length; ++x) {
                val[cIndex] = array[x];
                --cIndex;
            }
            return val;
        }
    }

    private class FoundItem {
        public int start;
        public int end;
        public int len;

        public FoundItem() {
        }

        public FoundItem(int start, int end) {
            this.start = start;
            this.end = end;
            this.len = end - start + 1;
        }
    }
}

