/*
 * Decompiled with CFR 0.152.
 */
package Chromatograms;

import Chromatograms.ChromatPanel;
import Chromatograms.Chromatogram;
import MouseMenuListeners.Listeners;
import ScrollPanels.StatusLabel;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import plaf.BaseRootPaneUI;

public class ChromatForm
extends JFrame {
    protected Chromatogram chromat;
    protected final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                ChromatForm.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            ChromatForm.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    public ChromatPanel chromatViewer;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    protected JMenuBar menuBar;
    private JMenuItem mnuClose;
    private JMenu mnuEdit;
    protected JMenu mnuFile;
    private JMenuItem mnuFind;
    private JMenuItem mnuFindNext;
    private JMenuItem mnuFindPrev;
    private JMenu mnuPeaks;
    private JMenuItem mnuScrollEnd;
    private JMenuItem mnuScrollLeft;
    private JMenuItem mnuScrollRight;
    private JMenuItem mnuScrollStart;
    private JMenuItem mnuToggleA;
    private JMenuItem mnuToggleC;
    private JMenuItem mnuToggleG;
    private JMenuItem mnuToggleT;
    private StatusLabel statusLabel;

    public String getKey() {
        return this.chromat.treeKey;
    }

    public ChromatForm() {
        this.setupChromatViewer();
    }

    public ChromatForm(Chromatogram srcChromat) {
        this.setupChromatViewer();
        this.setChromat(srcChromat);
    }

    public void setAntisense(boolean sense) {
        this.chromatViewer.setAntisense(sense);
    }

    private void setupChromatViewer() {
        this.initComponents();
        Listeners.setMenuBarListeners(this.menuBar, this.menuMouseListener);
        BaseRootPaneUI.addHorizontalSizer(this, this.menuMouseListener);
        JPanel contentPane = (JPanel)this.getContentPane();
        int condition = 2;
        InputMap inputMap = contentPane.getInputMap(condition);
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0, true), "esc");
        actionMap.put("esc", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ChromatForm.this.beforeClose();
                ChromatForm.this.dispose();
            }
        });
        this.chromatViewer.autoScale();
        this.chromatViewer.requestFocus();
    }

    public void setChromat(Chromatogram chromat) {
        this.chromatViewer.setChromatogram(chromat);
    }

    private void initComponents() {
        this.statusLabel = new StatusLabel();
        this.chromatViewer = new ChromatPanel();
        this.menuBar = new JMenuBar();
        this.mnuFile = new JMenu();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.mnuClose = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.mnuEdit = new JMenu();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.mnuFind = new JMenuItem();
        this.mnuFindNext = new JMenuItem();
        this.mnuFindPrev = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.mnuScrollStart = new JMenuItem();
        this.mnuScrollEnd = new JMenuItem();
        this.mnuScrollRight = new JMenuItem();
        this.mnuScrollLeft = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.mnuPeaks = new JMenu();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.mnuToggleA = new JMenuItem();
        this.mnuToggleC = new JMenuItem();
        this.mnuToggleG = new JMenuItem();
        this.mnuToggleT = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Chromatogram Viewer");
        this.mnuFile.setText("File");
        this.jSeparator6.setToolTipText("Close");
        this.mnuFile.add(this.jSeparator6);
        this.mnuClose.setBackground(new Color(255, 255, 255));
        this.mnuClose.setText("Close Window");
        this.mnuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuCloseActionPerformed(evt);
            }
        });
        this.mnuFile.add(this.mnuClose);
        this.mnuFile.add(this.jSeparator7);
        this.menuBar.add(this.mnuFile);
        this.mnuEdit.setText("Edit");
        this.jSeparator4.setToolTipText("Find");
        this.mnuEdit.add(this.jSeparator4);
        this.mnuFind.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.mnuFind.setBackground(new Color(255, 255, 255));
        this.mnuFind.setText("Find Sequence");
        this.mnuEdit.add(this.mnuFind);
        this.mnuFindNext.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.mnuFindNext.setBackground(new Color(255, 255, 255));
        this.mnuFindNext.setText("Find Next");
        this.mnuFindNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuFindNextActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuFindNext);
        this.mnuFindPrev.setAccelerator(KeyStroke.getKeyStroke(114, 128));
        this.mnuFindPrev.setBackground(new Color(255, 255, 255));
        this.mnuFindPrev.setText("Find Previous");
        this.mnuFindPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuFindPrevActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuFindPrev);
        this.jSeparator1.setToolTipText("Scroll");
        this.mnuEdit.add(this.jSeparator1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.jMenuItem2.setText("Copy selected");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.jMenuItem2);
        this.jSeparator9.setToolTipText("Scroll");
        this.mnuEdit.add(this.jSeparator9);
        this.mnuScrollStart.setAccelerator(KeyStroke.getKeyStroke(36, 0));
        this.mnuScrollStart.setText("Scroll to Start");
        this.mnuScrollStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuScrollStartActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuScrollStart);
        this.mnuScrollEnd.setAccelerator(KeyStroke.getKeyStroke(35, 0));
        this.mnuScrollEnd.setText("Scroll to End");
        this.mnuScrollEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuScrollEndActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuScrollEnd);
        this.mnuScrollRight.setAccelerator(KeyStroke.getKeyStroke(34, 0));
        this.mnuScrollRight.setBackground(new Color(255, 255, 255));
        this.mnuScrollRight.setText("Scroll Right");
        this.mnuScrollRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuScrollRightActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuScrollRight);
        this.mnuScrollLeft.setAccelerator(KeyStroke.getKeyStroke(33, 0));
        this.mnuScrollLeft.setBackground(new Color(255, 255, 255));
        this.mnuScrollLeft.setText("Scroll Left");
        this.mnuScrollLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuScrollLeftActionPerformed(evt);
            }
        });
        this.mnuEdit.add(this.mnuScrollLeft);
        this.mnuEdit.add(this.jSeparator5);
        this.menuBar.add(this.mnuEdit);
        this.mnuPeaks.setText("Peaks");
        this.jSeparator2.setToolTipText("Toggle Peaks");
        this.mnuPeaks.add(this.jSeparator2);
        this.mnuToggleA.setAccelerator(KeyStroke.getKeyStroke(65, 128));
        this.mnuToggleA.setBackground(new Color(255, 255, 255));
        this.mnuToggleA.setText("Toggle \"A\" Peaks");
        this.mnuToggleA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuToggleAActionPerformed(evt);
            }
        });
        this.mnuPeaks.add(this.mnuToggleA);
        this.mnuToggleC.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.mnuToggleC.setBackground(new Color(255, 255, 255));
        this.mnuToggleC.setText("Toggle \"C\" Peaks");
        this.mnuToggleC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuToggleCActionPerformed(evt);
            }
        });
        this.mnuPeaks.add(this.mnuToggleC);
        this.mnuToggleG.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.mnuToggleG.setBackground(new Color(255, 255, 255));
        this.mnuToggleG.setText("Toggle \"G\" Peaks");
        this.mnuToggleG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuToggleGActionPerformed(evt);
            }
        });
        this.mnuPeaks.add(this.mnuToggleG);
        this.mnuToggleT.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        this.mnuToggleT.setBackground(new Color(255, 255, 255));
        this.mnuToggleT.setText("Toggle \"T\" Peaks");
        this.mnuToggleT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.mnuToggleTActionPerformed(evt);
            }
        });
        this.mnuPeaks.add(this.mnuToggleT);
        this.jSeparator3.setToolTipText("Autoscale");
        this.mnuPeaks.add(this.jSeparator3);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        this.jMenuItem1.setText("Autoscale Peaks");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChromatForm.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.mnuPeaks.add(this.jMenuItem1);
        this.jSeparator8.setToolTipText("");
        this.mnuPeaks.add(this.jSeparator8);
        this.menuBar.add(this.mnuPeaks);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, -1, 671, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.chromatViewer, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.chromatViewer, -1, 401, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2)));
        this.pack();
    }

    protected void beforeClose() {
    }

    private void mnuCloseActionPerformed(ActionEvent evt) {
        this.beforeClose();
        this.dispose();
    }

    private void mnuFindNextActionPerformed(ActionEvent evt) {
        this.chromatViewer.findNext();
    }

    private void mnuScrollRightActionPerformed(ActionEvent evt) {
        this.chromatViewer.scrollRight();
    }

    private void mnuScrollLeftActionPerformed(ActionEvent evt) {
        this.chromatViewer.scrollLeft();
    }

    private void mnuScrollStartActionPerformed(ActionEvent evt) {
        this.chromatViewer.scrollToStart();
    }

    private void mnuScrollEndActionPerformed(ActionEvent evt) {
        this.chromatViewer.scrollToEnd();
    }

    private void mnuToggleCActionPerformed(ActionEvent evt) {
        this.chromatViewer.TogglePeaksC();
    }

    private void mnuToggleAActionPerformed(ActionEvent evt) {
        this.chromatViewer.TogglePeaksA();
    }

    private void mnuToggleGActionPerformed(ActionEvent evt) {
        this.chromatViewer.TogglePeaksG();
    }

    private void mnuToggleTActionPerformed(ActionEvent evt) {
        this.chromatViewer.TogglePeaksT();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.chromatViewer.autoScale();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.chromatViewer.copy();
    }

    private void mnuFindPrevActionPerformed(ActionEvent evt) {
        this.chromatViewer.findPrevious();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ChromatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ChromatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ChromatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ChromatForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ChromatForm().setVisible(true);
            }
        });
    }
}

