/*
 * Decompiled with CFR 0.152.
 */
package CheckedListBox;

import CheckedListBox.CheckListItem;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class CheckListBox
extends JScrollPane {
    private JList clb;
    private CheckboxListCellRenderer renderer;
    private final JMenuItem mnuCheckAll = new JMenuItem("Check all items");
    private final JMenuItem mnuCheckAllSel = new JMenuItem("Check all selected items");
    private final JMenuItem mnuCheckUnsel = new JMenuItem("Check all unselected items");
    private final JMenuItem mnuUncheckAll = new JMenuItem("Uncheck all items");
    private final JMenuItem mnuUncheckAllSel = new JMenuItem("Uncheck all selected items");
    private final JMenuItem mnuUncheckUnsel = new JMenuItem("Uncheck all unselected items");
    private final JMenuItem mnuInvert = new JMenuItem("Invert checks of all items");
    private final JMenuItem mnuInvertSel = new JMenuItem("Invert checks of selected items");
    public DefaultListModel<CheckListItem> listModel;

    public JList getListBox() {
        return this.clb;
    }

    public CheckListBox() {
        this.init(new DefaultListModel<CheckListItem>());
    }

    public CheckListBox(DefaultListModel<CheckListItem> checklistModel) {
        this.init(checklistModel);
    }

    private static JPopupMenu.Separator genToolTipSep(String toolTipText) {
        JPopupMenu.Separator sep = new JPopupMenu.Separator();
        sep.setToolTipText(toolTipText);
        return sep;
    }

    private void init(DefaultListModel<CheckListItem> checklistModel) {
        this.clb = new JList();
        this.renderer = new CheckboxListCellRenderer();
        this.clb.setFont(this.getFont());
        this.renderer.setFont(this.getFont());
        this.clb.setCellRenderer(this.renderer);
        this.listModel = checklistModel;
        this.clb.setModel(this.listModel);
        this.setViewportView(this.clb);
        this.clb.setDoubleBuffered(true);
        this.setDoubleBuffered(true);
        this.clb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (CheckListBox.this.listModel.getSize() == 0) {
                    return;
                }
                if (evt.getButton() == 1 && (evt.getX() < 20 || evt.getClickCount() == 2)) {
                    CheckListBox.this.listModel.get((int)((CheckListBox)CheckListBox.this).clb.getSelectedIndex()).checked = !CheckListBox.this.listModel.get((int)((CheckListBox)CheckListBox.this).clb.getSelectedIndex()).checked;
                    CheckListBox.this.repaint();
                } else if (evt.getButton() == 3 && evt.getClickCount() == 1) {
                    boolean haveSelected = CheckListBox.this.clb.getSelectedIndices().length > 0;
                    JPopupMenu menu = new JPopupMenu();
                    menu.add(CheckListBox.genToolTipSep("Check Items"));
                    menu.add(CheckListBox.this.mnuCheckAll);
                    if (haveSelected) {
                        menu.add(CheckListBox.this.mnuCheckAllSel);
                    }
                    if (haveSelected) {
                        menu.add(CheckListBox.this.mnuCheckUnsel);
                    }
                    menu.add(CheckListBox.genToolTipSep("Uncheck Items"));
                    menu.add(CheckListBox.this.mnuUncheckAll);
                    if (haveSelected) {
                        menu.add(CheckListBox.this.mnuUncheckAllSel);
                    }
                    if (haveSelected) {
                        menu.add(CheckListBox.this.mnuUncheckUnsel);
                    }
                    menu.add(CheckListBox.genToolTipSep("Invert Check"));
                    menu.add(CheckListBox.this.mnuInvert);
                    if (haveSelected) {
                        menu.add(CheckListBox.this.mnuInvertSel);
                    }
                    menu.show((JList)evt.getSource(), evt.getX(), evt.getY());
                }
            }
        });
        this.mnuCheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < CheckListBox.this.listModel.size(); ++x) {
                    CheckListBox.this.listModel.getElementAt((int)x).checked = true;
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuCheckAllSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = CheckListBox.this.clb.getSelectedIndices();
                for (int x = 0; x < index.length; ++x) {
                    CheckListBox.this.listModel.getElementAt((int)index[x]).checked = true;
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuCheckUnsel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = CheckListBox.this.clb.getSelectedIndices();
                for (int x = 0; x < index.length; ++x) {
                    CheckListBox.this.listModel.getElementAt((int)index[x]).checked = false;
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuUncheckAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < CheckListBox.this.listModel.size(); ++x) {
                    CheckListBox.this.listModel.getElementAt((int)x).checked = false;
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuUncheckAllSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = CheckListBox.this.clb.getSelectedIndices();
                for (int x = 0; x < index.length; ++x) {
                    CheckListBox.this.listModel.getElementAt((int)index[x]).checked = false;
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuUncheckUnsel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = CheckListBox.this.clb.getSelectedIndices();
                for (int x = 0; x < index.length; ++x) {
                    CheckListBox.this.listModel.getElementAt((int)index[x]).checked = false;
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuInvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int x = 0; x < CheckListBox.this.listModel.size(); ++x) {
                    CheckListBox.this.listModel.getElementAt(x).toggleCheck();
                }
                CheckListBox.this.repaint();
            }
        });
        this.mnuInvertSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] index = CheckListBox.this.clb.getSelectedIndices();
                for (int x = 0; x < index.length; ++x) {
                    CheckListBox.this.listModel.getElementAt(index[x]).toggleCheck();
                }
                CheckListBox.this.repaint();
            }
        });
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.renderer != null) {
            this.renderer.setFont(font);
        }
        if (this.clb != null) {
            this.clb.setFont(font);
        }
    }

    public int[] getChecked() {
        int count = 0;
        for (int x = 0; x < this.listModel.getSize(); ++x) {
            if (!this.listModel.get((int)x).checked) continue;
            ++count;
        }
        int[] outInts = new int[count];
        int index = 0;
        for (int x = 0; x < this.listModel.getSize(); ++x) {
            if (!this.listModel.get((int)x).checked) continue;
            outInts[index] = x;
            ++index;
        }
        return outInts;
    }

    public void setIcon(Icon icon) {
        this.renderer.setIcon(icon);
    }

    public Icon getIcon() {
        return this.renderer.getIcon();
    }

    public void setSelectedIcon(Icon icon) {
        this.renderer.setSelectedIcon(icon);
    }

    public Icon getSelectedIcon() {
        return this.renderer.getSelectedIcon();
    }

    private boolean isValidIndex(int itemIndex) {
        return itemIndex >= 0 && itemIndex <= this.listModel.getSize();
    }

    public CheckListItem getItem(int itemIndex) {
        return this.isValidIndex(itemIndex) ? this.listModel.getElementAt(itemIndex) : null;
    }

    public class CheckboxListCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CheckListItem item = (CheckListItem)value;
            this.setComponentOrientation(list.getComponentOrientation());
            this.setFont(list.getFont());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setSelected(item.checked);
            this.setEnabled(list.isEnabled());
            this.setText(item.text == null ? "" : item.text);
            this.setIconTextGap(7);
            return this;
        }
    }
}

