/*
 * Decompiled with CFR 0.152.
 */
package Canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class Canvas {
    public Color backColor = Color.white;
    BufferedImage image = null;
    Graphics2D graphics = null;
    int width = 1;
    int height = 1;

    public Canvas() {
    }

    public Canvas(int width, int height) {
        this.setSize(width, height);
    }

    public BufferedImage getImage() {
        if (this.image == null || this.graphics == null) {
            this.generateImage();
        }
        return this.image;
    }

    public Graphics getGraphics() {
        if (this.image == null || this.graphics == null) {
            this.generateImage();
        }
        return this.graphics;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(int width, int height) {
        if (width != this.width || height != this.height || this.image == null || this.graphics == null) {
            this.generateImage(width, height);
        }
    }

    static boolean hasSameDimensions(Canvas me, Canvas canvas) {
        return canvas.height == me.height && canvas.width == me.width;
    }

    public static boolean copyCanvas(Canvas source, Canvas dest) {
        if (source.hasImage()) {
            dest.setSize(source.width, source.height);
            dest.graphics.drawImage((Image)source.image, 0, 0, null);
            return true;
        }
        return false;
    }

    public boolean copyFrom(Canvas canvas) {
        return Canvas.copyCanvas(canvas, this);
    }

    public boolean copyTo(Canvas canvas) {
        return Canvas.copyCanvas(this, canvas);
    }

    public boolean hasImage() {
        return this.image != null && this.graphics != null;
    }

    public void resetImage() {
        this.image = null;
        this.graphics = null;
        this.generateImage(this.width, this.height);
    }

    private void generateImage(int width, int height) {
        this.width = width;
        this.height = height;
        this.generateImage();
    }

    private void generateImage() {
        this.image = new BufferedImage(this.width, this.height, 6);
        this.graphics = (Graphics2D)this.image.getGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.backColor != null) {
            this.graphics.setColor(this.backColor);
            this.graphics.fillRect(0, 0, this.width, this.height);
        }
    }
}

