/*
 * Decompiled with CFR 0.152.
 */
package Buttons;

import Buttons.Constants;
import Buttons.LongPressProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanProperty;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;

public class LongPressToggleButton
extends JToggleButton
implements MouseListener,
FocusListener {
    final LongPressProperties properties = new LongPressProperties();

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.properties.stopTimer();
    }

    public void add(JMenuItem item) {
        this.properties.getMenu().add(item);
    }

    public int getArrowHeight() {
        return this.properties.arrowHt;
    }

    @BeanProperty(preferred=true, description="Sets the height of the arrow drawn over the icon.")
    public void setArrowHeight(int value) {
        this.properties.setArrowHeight(value);
        this.repaint();
    }

    public int getMouseButtonMenuTrigger() {
        return this.properties.menuOnButton;
    }

    @BeanProperty(preferred=true, description="Sets which mouse button triggers the menu on long hold.")
    public void setMouseButtonMenuTrigger(int button) {
        if (button > 0 && button < 4) {
            this.properties.menuOnButton = button;
        }
    }

    public int getArrowWidth() {
        return this.properties.arrowWd;
    }

    @BeanProperty(preferred=true, description="Sets the width of the arrow drawn over the icon.")
    public void setArrowWidth(int value) {
        this.properties.setArrowWidth(value);
        this.repaint();
    }

    public int getArrowInset() {
        return this.properties.arrowSpacer;
    }

    @BeanProperty(preferred=true, description="Sets the inset from the border of the arrow drawn over the icon.")
    public void setArrowInset(int value) {
        this.properties.setArrowInset(value);
        this.repaint();
    }

    @BeanProperty(preferred=true, description="Sets the fill color of the arrow drawn over the icon.")
    public void setArrowColor(Color color) {
        this.properties.setArrowColor(color);
        this.repaint();
    }

    public Color getArrowColor() {
        return this.properties.arrowFillColor;
    }

    @BeanProperty(preferred=true, description="Sets the border color of the arrow drawn over the icon.")
    public void setArrowLineColor(Color color) {
        this.properties.setArrowLineColor(color);
        this.repaint();
    }

    public Color getArrowLineColor() {
        return this.properties.arrowLineColor;
    }

    public Constants.PopupLocation getMenuPopUpLocation() {
        return this.properties.menuPos;
    }

    @BeanProperty(preferred=true, description="Sets the location where a popup menu will show on long press.")
    public void setMenuPopUpLocation(Constants.PopupLocation pos) {
        this.properties.setMenuPopUpLocation(pos);
    }

    public Constants.PopupLocation getArrowLocation() {
        return this.properties.menuPos;
    }

    @BeanProperty(preferred=true, description="Sets the location to draw the arrow drawn over the icon.")
    public void setArrowLocation(Constants.PopupLocation pos) {
        this.properties.setArrowLocation(pos);
        this.repaint();
    }

    public JPopupMenu getPopupMenu() {
        return this.properties.getMenu();
    }

    public boolean isShowArrow() {
        return this.properties.showArrow;
    }

    @BeanProperty(preferred=true, description="Sets whether the arrow drawn over the icon is visible by default.")
    public void setShowArrow(boolean show) {
        this.properties.showArrow = show;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.properties.menu = menu;
    }

    @BeanProperty(preferred=true, description="Sets delay time in ms after press before the menu is shown.")
    public int getDelay() {
        return this.properties.delay;
    }

    public void setDelay(int delay) {
        this.properties.delay = delay;
    }

    private void startTimer() {
        this.properties.startTimer(this);
    }

    public LongPressToggleButton() {
        this.init();
    }

    private void init() {
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isArmed() {
                if (!this.isEnabled()) {
                    return false;
                }
                return super.isArmed() && (LongPressToggleButton.this.properties.timer == null && LongPressToggleButton.this.properties.menuOnButton != 1 || LongPressToggleButton.this.properties.timer != null && LongPressToggleButton.this.properties.menuOnButton == 1);
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.properties.stopTimer();
        if (!this.isEnabled()) {
            return;
        }
        if (e.getButton() == this.properties.menuOnButton) {
            this.startTimer();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.properties.stopTimer();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.properties.stopTimer();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.properties.showArrow) {
            this.properties.paint(g, this.getWidth(), this.getHeight(), this.isEnabled());
        }
    }
}

