/*
 * Decompiled with CFR 0.152.
 */
package BioDocumentFilters;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public abstract class BioKeyFilter
extends DocumentFilter {
    public static final String FILTER_GB_NAME = "\\w\\-'";
    public static final String FILTER_AA = "[^*ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy]";
    public static final String FILTER_NUMBER = "[^0123456789]";
    public static final String FILTER_LOWERCASE = "a-z";
    public static final String FILTER_UPPERCASE = "A-Z";
    public static final String FILTER_ALPHA = "a-zA-Z";
    public static final String FILTER_NUMERIC = "0-9";
    public static final String FILTER_FLOAT = "[^0123456789]\\.";
    public static final String FILTER_ALPHANUMERIC = "a-zA-Z0-9";
    public static final String FILTER_ATGC = "ATGCatgc";
    public static final String FILTER_DNA = "[^atgcnATGCN]";
    public static final String FILTER_ATGCN_GAP = "[^atgcnATGCN]-";
    public static final String FILTER_AUGC = "AUGCaugc";
    public static final String FILTER_AUGCN = "AUGCaugcNn";
    public static final String FILTER_AMINO_ACIDS = "ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy*";
    public static final String FILTER_AMINO_ACIDS_GAP = "ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy-*";
    public static final BioKeyFilter DNAFilter = new BioKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(BioKeyFilter.FILTER_DNA, "");
        }
    };
    public static final BioKeyFilter DNAGapFilter = new BioKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(BioKeyFilter.FILTER_ATGCN_GAP, "");
        }
    };
    public static final BioKeyFilter ProteinFilter = new BioKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(BioKeyFilter.FILTER_AA, "");
        }
    };
    public static final BioKeyFilter ProteinGapFilter = new BioKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(BioKeyFilter.FILTER_AMINO_ACIDS_GAP, "");
        }
    };
    public static final BioKeyFilter NumberFilter = new BioKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(BioKeyFilter.FILTER_NUMBER, "");
        }
    };
    public static final BioKeyFilter GenbankNameFilter = new BioKeyFilter(){

        @Override
        public String filterText(String text) {
            return text.replaceAll(BioKeyFilter.FILTER_GB_NAME, "");
        }
    };

    public abstract String filterText(String var1);

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, offset, this.filterText(text), attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(fb, offset, length, this.filterText(text), attrs);
    }
}

