/*
 * Decompiled with CFR 0.152.
 */
package BaseClasses;

import JMConstants.Constants;
import Tools.UITools;
import java.awt.Color;
import java.awt.Component;

public class RendererColors
implements Constants {
    public static final int DEFAULT_TYPES_COUNT = 3;
    public static final int DEFAULT_STATE_COUNT = 7;
    private int stateCount = 7;
    private int typeCount = 3;
    private Color[][] colors = new Color[this.typeCount][this.stateCount];
    protected Color[] activeColors = new Color[this.typeCount];

    public RendererColors() {
    }

    public RendererColors(int typeCount) {
        this.colors = new Color[typeCount][this.stateCount];
        this.activeColors = new Color[typeCount];
        this.typeCount = typeCount;
    }

    public RendererColors(int typeCount, int stateCount) {
        this.colors = new Color[typeCount][stateCount];
        this.activeColors = new Color[typeCount];
        this.typeCount = typeCount;
        this.stateCount = stateCount;
    }

    public void setMinimumTypesAndStates(int typeCount, int stateCount) {
        if (this.typeCount >= typeCount && this.stateCount >= stateCount) {
            return;
        }
        Color[][] tmpColors = new Color[typeCount][stateCount];
        Color[] tmpActiveColors = new Color[typeCount];
        for (int x = 0; x < this.colors.length; ++x) {
            System.arraycopy(this.colors[x], 0, tmpColors[x], 0, this.colors[x].length);
        }
        System.arraycopy(this.activeColors, 0, tmpActiveColors, 0, this.activeColors.length);
        this.colors = tmpColors;
        this.activeColors = tmpActiveColors;
        this.typeCount = typeCount;
        this.stateCount = stateCount;
    }

    public void setMinimumStates(int minStates) {
        if (this.stateCount < minStates) {
            this.setMinimumTypesAndStates(this.typeCount, minStates);
        }
    }

    public void setMinimumTypes(int minTypes) {
        if (this.typeCount < minTypes) {
            this.setMinimumTypesAndStates(minTypes, this.stateCount);
        }
    }

    public Color getColor(int colorType, int state) {
        if (this.colors == null || colorType < 0 || colorType >= this.colors.length || this.colors[colorType] == null || state < 0 || state >= this.colors[colorType].length) {
            return Color.BLACK;
        }
        return this.colors[colorType][state];
    }

    public Color getColor(Component c, int colorType, int state) {
        if (this.colors == null || colorType < 0 || colorType >= this.colors.length || this.colors[colorType] == null || state < 0 || state >= this.colors[colorType].length) {
            if (!c.isEnabled()) {
                if (colorType == 1) {
                    return c.getBackground().brighter();
                }
                return c.getBackground().darker();
            }
            if (colorType == 1) {
                return c.getBackground();
            }
            if (colorType == 1) {
                return c.getForeground();
            }
            return c.getBackground().darker();
        }
        return this.colors[colorType][state];
    }

    public void setColor(int colorType, int state, Color color) {
        if (this.colors != null && colorType >= 0 && colorType < this.colors.length && this.colors[colorType] != null && state >= 0 && state < this.colors[colorType].length) {
            this.colors[colorType][state] = color;
        }
    }

    public void setTypeColors(int colorType, Color ... colors) {
        if (this.colors == null || colors == null || colorType < 0 || colorType >= colors.length || colors[colorType] == null) {
            return;
        }
        int minCount = Math.min(this.colors[colorType].length, colors.length);
        System.arraycopy(colors, 0, this.colors[colorType], 0, minCount);
    }

    public void setColors(int colorType, Color color) {
        if (this.colors == null || colorType < 0 || colorType >= this.colors.length || this.colors[colorType] == null || this.colors[colorType].length == 0) {
            return;
        }
        for (int x = 0; x < this.colors[colorType].length; ++x) {
            this.colors[colorType][x] = color;
        }
    }

    public void setColors(int colorType, Color defaultColor, Color pressedColor, Color disabledColor, Color selectedColor, Color disabledSelectedColor, Color rolloverColor, Color rolloverSelectedColor) {
        if (this.colors == null || colorType < 0 || colorType >= this.colors.length) {
            return;
        }
        this.colors[colorType][0] = defaultColor;
        this.colors[colorType][1] = pressedColor;
        this.colors[colorType][2] = disabledColor;
        this.colors[colorType][3] = selectedColor;
        this.colors[colorType][4] = disabledSelectedColor;
        this.colors[colorType][5] = rolloverColor;
        this.colors[colorType][6] = rolloverSelectedColor;
    }

    public void setActiveColors(Component c) {
        int state = UITools.getState(c);
        this.setActiveColors(state);
    }

    public void setActiveColors(boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        int state = 0;
        state = enabled ? (selected ? 3 : (rollOver && !pressed ? 5 : (pressed ? 1 : 0))) : (selected ? 4 : 2);
        this.setActiveColors(state);
    }

    public void setActiveColors(int state) {
        if (state >= 0 && state < this.colors[0].length) {
            for (int x = 0; x < this.activeColors.length; ++x) {
                this.activeColors[x] = this.getColor(x, state);
            }
        }
    }

    public Color getActiveColor(int colorType) {
        if (this.activeColors == null || colorType < 0 || colorType >= this.activeColors.length) {
            return null;
        }
        return this.activeColors[colorType];
    }

    public RendererColors clone() {
        RendererColors clone = new RendererColors();
        clone.cloneFrom(this);
        return clone;
    }

    public void cloneTo(RendererColors clone) {
        if (this.colors != null && this.colors.length > 0 && this.colors[0] != null && this.colors[0].length > 0) {
            clone.colors = new Color[this.colors.length][this.colors[0].length];
            clone.activeColors = new Color[this.colors.length];
            for (int x = 0; x < this.colors.length; ++x) {
                System.arraycopy(this.colors[x], 0, clone.colors[x], 0, this.colors[x].length);
            }
            clone.stateCount = this.colors[0].length;
            clone.typeCount = this.colors.length;
        }
    }

    public void cloneFrom(RendererColors clone) {
        if (clone.colors != null && clone.colors.length > 0 && clone.colors[0] != null && clone.colors[0].length > 0) {
            this.colors = new Color[clone.colors.length][clone.colors[0].length];
            this.activeColors = new Color[clone.colors.length];
            for (int x = 0; x < clone.colors.length; ++x) {
                System.arraycopy(clone.colors[x], 0, this.colors[x], 0, clone.colors[x].length);
            }
            this.stateCount = this.colors[0].length;
            this.typeCount = this.colors.length;
        }
    }
}

