/*
 * Decompiled with CFR 0.152.
 */
package BaseClasses;

import BaseClasses.RendererColors;
import JMConstants.Constants;
import Tools.UITools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractStatedIcon
implements Icon,
Constants {
    protected RendererColors colors = new RendererColors();
    protected int width = 16;
    protected int height = 16;
    protected boolean needsRegen = true;
    protected Icon[] icons;
    private Icon errorIcon = null;

    public AbstractStatedIcon() {
        this.initIconsArray();
    }

    protected void initIconsArray() {
        this.icons = new Icon[7];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getIcon(UITools.getState(c));
        if (icon != null) {
            icon.paintIcon(c, g, x, y);
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y, int state) {
        this.icons[state].paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public void setSize(int width, int height) {
        if (width == 0 && height == 0) {
            return;
        }
        if (width > 0) {
            this.width = width;
        }
        if (height > 0) {
            this.height = height;
        }
        this.needsRegen = true;
    }

    public void resetIcons() {
        for (int x = 0; x < this.icons.length; ++x) {
            this.icons[x] = null;
        }
        this.errorIcon = null;
        this.needsRegen = false;
    }

    protected void regenIcon(int state) {
        switch (state) {
            case 0: {
                this.icons[0] = this.makeIcon(true, false, false, false);
                break;
            }
            case 4: {
                this.icons[4] = this.makeIcon(false, true, false, false);
                break;
            }
            case 2: {
                this.icons[2] = this.makeIcon(false, false, false, false);
                break;
            }
            case 1: {
                this.icons[1] = this.makeIcon(true, false, false, true);
                break;
            }
            case 6: {
                this.icons[6] = this.makeIcon(true, true, true, false);
                break;
            }
            case 3: {
                this.icons[3] = this.makeIcon(true, true, false, false);
                break;
            }
            case 5: {
                this.icons[5] = this.makeIcon(true, false, true, true);
                break;
            }
            case -1: {
                this.genErrorIcon();
            }
        }
    }

    public Icon getIcon(Component c) {
        if (this.needsRegen) {
            this.resetIcons();
        }
        return this.getIcon(UITools.getState(c));
    }

    private Icon getErrorIcon() {
        if (this.errorIcon == null) {
            this.genErrorIcon();
        }
        return this.errorIcon;
    }

    protected void genErrorIcon() {
        BufferedImage canvasBuffer = new BufferedImage(this.width, this.height, 6);
        Graphics2D canvasGraphics = (Graphics2D)canvasBuffer.getGraphics();
        canvasGraphics.setColor(Color.white);
        canvasGraphics.fillRect(0, 0, this.width, this.height);
        canvasGraphics.setColor(Color.red);
        canvasGraphics.drawLine(0, 0, this.width, this.height);
        canvasGraphics.drawLine(0, this.height, this.width, 0);
        canvasGraphics.drawRect(0, 0, this.width - 1, this.height - 1);
        this.errorIcon = new ImageIcon(canvasBuffer);
    }

    private Icon makeIcon(boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        BufferedImage buffer = new BufferedImage(this.width, this.height, 6);
        Graphics2D g2d = (Graphics2D)buffer.getGraphics();
        return this.drawIcon(g2d, enabled, selected, rollOver, pressed) ? new ImageIcon(buffer) : null;
    }

    public abstract boolean drawIcon(Graphics2D var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public Icon getIcon(int state) {
        switch (state) {
            case 2: {
                return this.getDisabledIcon();
            }
            case 4: {
                return this.getDisabledSelectedIcon();
            }
            case 1: {
                return this.getPressedIcon();
            }
            case 6: {
                return this.getRolloverSelectedIcon();
            }
            case 3: {
                return this.getSelectedIcon();
            }
            case 5: {
                return this.getRolloverIcon();
            }
        }
        return this.getIcon();
    }

    protected Icon getGenIcon(int state) {
        if (this.icons[state] == null) {
            this.regenIcon(state);
        }
        return this.icons[state];
    }

    protected Icon getIcon() {
        return this.getGenIcon(0) != null ? this.icons[0] : this.getErrorIcon();
    }

    private Icon getDisabledSelectedIcon() {
        return this.getGenIcon(4) != null ? this.icons[4] : this.getDisabledIcon();
    }

    private Icon getDisabledIcon() {
        return this.getGenIcon(2) != null ? this.icons[2] : this.getIcon();
    }

    private Icon getPressedIcon() {
        return this.getGenIcon(1) != null ? this.icons[1] : this.getIcon();
    }

    private Icon getRolloverSelectedIcon() {
        return this.getGenIcon(6) != null ? this.icons[6] : this.getSelectedIcon();
    }

    private Icon getSelectedIcon() {
        return this.getGenIcon(3) != null ? this.icons[3] : this.getIcon();
    }

    private Icon getRolloverIcon() {
        return this.getGenIcon(5) != null ? this.icons[5] : this.getIcon();
    }

    public Color getColor(int colorType, int state) {
        return this.colors.getColor(colorType, state);
    }

    public RendererColors getColors() {
        return this.colors;
    }

    public void setColor(int colorType, int state, Color color) {
        this.colors.setColor(colorType, state, color);
        this.needsRegen = true;
    }

    public void setColors(int colorType, Color color) {
        this.colors.setColors(colorType, color);
        this.needsRegen = true;
    }

    public void setColors(RendererColors colors) {
        this.colors = colors;
        this.needsRegen = true;
    }

    protected void setActiveColors(boolean enabled, boolean selected, boolean rollOver, boolean pressed) {
        this.colors.setActiveColors(enabled, selected, rollOver, pressed);
    }

    public Color getActiveColor(int state) {
        return this.colors.getActiveColor(state);
    }
}

