/*
 * Decompiled with CFR 0.152.
 */
package AlignmentTools;

import AlignmentTools.QuadAlignment;

public class PairwiseAlignment {
    private static StringBuilder alignedReference;
    private static StringBuilder alignedQuery;
    static String alignedQueryString;
    static String alignedReferenceString;
    static int score;
    private static char[] refChars;
    private static char[] qryChars;
    private static QuadAlignment.ScoreSet scoreSet;
    private static int[] Sn;
    private static int[] Sp;

    public static boolean align(String query, String reference) {
        return PairwiseAlignment.align(query.toCharArray(), reference.toCharArray(), new QuadAlignment.ScoreSet(), false);
    }

    public static boolean align(String query, String reference, int matchScore, int mismatchPenalty, int gapPenalty, int beginGapPenalty, int endGapPenalty) {
        QuadAlignment.ScoreSet scoreset = new QuadAlignment.ScoreSet(matchScore, mismatchPenalty, gapPenalty, beginGapPenalty, endGapPenalty);
        return PairwiseAlignment.align(query.toCharArray(), reference.toCharArray(), scoreset, false);
    }

    public static boolean align(String query, String reference, boolean convertTerminalGapsToSpaces) {
        return PairwiseAlignment.align(query.toCharArray(), reference.toCharArray(), new QuadAlignment.ScoreSet(), convertTerminalGapsToSpaces);
    }

    public static boolean align(String query, String reference, int matchScore, int mismatchPenalty, int gapPenalty, int beginGapPenalty, int endGapPenalty, boolean convertTerminalGapsToSpaces) {
        QuadAlignment.ScoreSet scoreset = new QuadAlignment.ScoreSet(matchScore, mismatchPenalty, gapPenalty, beginGapPenalty, endGapPenalty);
        return PairwiseAlignment.align(query.toCharArray(), reference.toCharArray(), scoreset, convertTerminalGapsToSpaces);
    }

    public static boolean align(char[] query, char[] reference) {
        return PairwiseAlignment.align(query, reference, new QuadAlignment.ScoreSet(), false);
    }

    public static boolean align(char[] query, char[] reference, int matchScore, int mismatchPenalty, int gapPenalty, int beginGapPenalty, int endGapPenalty) {
        QuadAlignment.ScoreSet scoreset = new QuadAlignment.ScoreSet(matchScore, mismatchPenalty, gapPenalty, beginGapPenalty, endGapPenalty);
        return PairwiseAlignment.align(query, reference, scoreset, false);
    }

    public static boolean align(char[] query, char[] reference, int matchScore, int mismatchPenalty, int gapPenalty, int beginGapPenalty, int endGapPenalty, boolean convertTerminalGapsToSpaces) {
        QuadAlignment.ScoreSet scoreset = new QuadAlignment.ScoreSet(matchScore, mismatchPenalty, gapPenalty, beginGapPenalty, endGapPenalty);
        return PairwiseAlignment.align(query, reference, scoreset, convertTerminalGapsToSpaces);
    }

    static boolean align(char[] query, char[] reference, QuadAlignment.ScoreSet scoreset, boolean convertTerminalGapsToSpaces) {
        boolean retVal = false;
        qryChars = query;
        refChars = reference;
        alignedQueryString = null;
        alignedReferenceString = null;
        alignedReference = new StringBuilder();
        alignedQuery = new StringBuilder();
        Sn = new int[reference.length + 1];
        Sp = new int[reference.length + 1];
        scoreSet = scoreset;
        score = 0;
        if (qryChars.length == 0) {
            for (int j = 0; j < refChars.length; ++j) {
                alignedQuery.append("-");
                alignedReference.append(refChars[j]);
            }
        } else if (refChars.length == 0) {
            for (int j = 0; j < qryChars.length; ++j) {
                alignedReference.append("-");
                alignedQuery.append(qryChars[j]);
            }
        } else if (qryChars.length > 0 || refChars.length > 0) {
            PairwiseAlignment.path(0, 0, qryChars.length, refChars.length);
            retVal = true;
        }
        if (convertTerminalGapsToSpaces) {
            alignedQueryString = PairwiseAlignment.convertTrailingGaps(alignedQuery);
            alignedReferenceString = PairwiseAlignment.convertTrailingGaps(alignedReference);
        } else {
            alignedQueryString = alignedQuery.toString();
            alignedReferenceString = alignedReference.toString();
        }
        alignedQuery = null;
        alignedReference = null;
        return retVal;
    }

    public static int getScore() {
        return score;
    }

    static String convertTrailingGaps(StringBuilder seq) {
        int x;
        int firstChar = 0;
        int lastChar = 0;
        for (x = 0; x < seq.length() && seq.charAt(x) == '-'; ++x) {
            seq.setCharAt(x, ' ');
        }
        for (x = seq.length() - 1; x > -1; --x) {
            if (seq.charAt(x) == '-') continue;
            lastChar = x;
            break;
        }
        if (firstChar == 0 && lastChar == 0) {
            return null;
        }
        return seq.substring(firstChar, lastChar + 1);
    }

    private static void path(int i1, int j1, int i2, int j2) {
        if (i1 + 1 == i2 || j1 == j2) {
            char[] subM = new char[i2 - i1];
            char[] subN = new char[j2 - j1];
            int index = 0;
            for (int mIndex = i1 + 1; mIndex <= i2; ++mIndex) {
                subM[index] = qryChars[mIndex - 1];
                ++index;
            }
            index = 0;
            for (int nIndex = j1 + 1; nIndex <= j2; ++nIndex) {
                subN[index] = refChars[nIndex - 1];
                ++index;
            }
            QuadAlignment.ScoreSet subScoreSet = new QuadAlignment.ScoreSet();
            if (j1 == j2) {
                if (j1 == 0) {
                    subScoreSet.setScoreSetParam(PairwiseAlignment.scoreSet.match, PairwiseAlignment.scoreSet.mismatch, PairwiseAlignment.scoreSet.beginGap, PairwiseAlignment.scoreSet.beginGap, PairwiseAlignment.scoreSet.beginGap);
                } else if (j1 == refChars.length) {
                    subScoreSet.setScoreSetParam(PairwiseAlignment.scoreSet.match, PairwiseAlignment.scoreSet.mismatch, PairwiseAlignment.scoreSet.endGap, PairwiseAlignment.scoreSet.endGap, PairwiseAlignment.scoreSet.endGap);
                } else {
                    subScoreSet.setScoreSetParam(PairwiseAlignment.scoreSet.match, PairwiseAlignment.scoreSet.mismatch, PairwiseAlignment.scoreSet.gap, PairwiseAlignment.scoreSet.gap, PairwiseAlignment.scoreSet.gap);
                }
            } else {
                subScoreSet.setScoreSetParam(PairwiseAlignment.scoreSet.match, PairwiseAlignment.scoreSet.mismatch, PairwiseAlignment.scoreSet.gap, PairwiseAlignment.scoreSet.beginGap, PairwiseAlignment.scoreSet.endGap);
                subScoreSet.useBeginGapTop = false;
                subScoreSet.useBeginGapLeft = false;
                subScoreSet.useEndGapBottom = false;
                subScoreSet.useEndGapRight = false;
                if (i1 == 0) {
                    subScoreSet.useBeginGapTop = true;
                }
                if (j1 == 0) {
                    subScoreSet.useBeginGapLeft = true;
                }
                if (j2 == refChars.length) {
                    subScoreSet.useEndGapRight = true;
                }
                if (i2 == qryChars.length) {
                    subScoreSet.useEndGapBottom = true;
                }
            }
            QuadAlignment.align(subM, subN, subScoreSet, false);
            alignedQuery.append(QuadAlignment.getAlignedQuery());
            alignedReference.append(QuadAlignment.getAlignedReference());
            score += QuadAlignment.getScore();
        } else {
            int j;
            int j3;
            int diag;
            int i;
            int nIndex;
            int middle = (int)Math.floor((i1 + i2) / 2);
            PairwiseAlignment.Sn[j1] = 0;
            if (i1 == 0) {
                for (nIndex = j1 + 1; nIndex <= j2; ++nIndex) {
                    PairwiseAlignment.Sn[nIndex] = Sn[nIndex - 1] + PairwiseAlignment.scoreSet.beginGap;
                }
            } else {
                for (nIndex = j1 + 1; nIndex <= j2; ++nIndex) {
                    PairwiseAlignment.Sn[nIndex] = Sn[nIndex - 1] + PairwiseAlignment.scoreSet.gap;
                }
            }
            for (i = i1 + 1; i <= middle; ++i) {
                diag = Sn[j1];
                if (j1 == 0) {
                    int n = j1;
                    Sn[n] = Sn[n] + PairwiseAlignment.scoreSet.beginGap;
                } else {
                    int n = j1;
                    Sn[n] = Sn[n] + PairwiseAlignment.scoreSet.gap;
                }
                int left = Sn[j1];
                for (j3 = j1 + 1; j3 <= j2; ++j3) {
                    left = j3 == refChars.length && i == qryChars.length ? Math.max(Sn[j3] + PairwiseAlignment.scoreSet.endGap, Math.max(left + PairwiseAlignment.scoreSet.endGap, diag + scoreSet.getScore(qryChars[i - 1], refChars[j3 - 1]))) : (i == qryChars.length ? Math.max(Sn[j3] + PairwiseAlignment.scoreSet.gap, Math.max(left + PairwiseAlignment.scoreSet.endGap, diag + scoreSet.getScore(qryChars[i - 1], refChars[j3 - 1]))) : (j3 == refChars.length ? Math.max(Sn[j3] + PairwiseAlignment.scoreSet.endGap, Math.max(left + PairwiseAlignment.scoreSet.gap, diag + scoreSet.getScore(qryChars[i - 1], refChars[j3 - 1]))) : Math.max(Sn[j3] + PairwiseAlignment.scoreSet.gap, Math.max(left + PairwiseAlignment.scoreSet.gap, diag + scoreSet.getScore(qryChars[i - 1], refChars[j3 - 1])))));
                    diag = Sn[j3];
                    PairwiseAlignment.Sn[j3] = left;
                }
            }
            PairwiseAlignment.Sp[j2] = 0;
            if (i2 == qryChars.length) {
                for (j = j2 - 1; j >= j1; --j) {
                    PairwiseAlignment.Sp[j] = Sp[j + 1] + PairwiseAlignment.scoreSet.endGap;
                }
            } else {
                for (j = j2 - 1; j >= j1; --j) {
                    PairwiseAlignment.Sp[j] = Sp[j + 1] + PairwiseAlignment.scoreSet.gap;
                }
            }
            for (i = i2 - 1; i >= middle; --i) {
                diag = Sp[j2];
                if (j2 == refChars.length) {
                    int n = j2;
                    Sp[n] = Sp[n] + PairwiseAlignment.scoreSet.endGap;
                } else {
                    int n = j2;
                    Sp[n] = Sp[n] + PairwiseAlignment.scoreSet.gap;
                }
                int right = Sp[j2];
                for (j3 = j2 - 1; j3 >= j1; --j3) {
                    right = j3 == 0 && i == 0 ? Math.max(Sp[j3] + PairwiseAlignment.scoreSet.beginGap, Math.max(right + PairwiseAlignment.scoreSet.beginGap, diag + scoreSet.getScore(qryChars[i], refChars[j3]))) : (j3 == 0 ? Math.max(Sp[j3] + PairwiseAlignment.scoreSet.beginGap, Math.max(right + PairwiseAlignment.scoreSet.gap, diag + scoreSet.getScore(qryChars[i], refChars[j3]))) : (i == 0 ? Math.max(Sp[j3] + PairwiseAlignment.scoreSet.gap, Math.max(right + PairwiseAlignment.scoreSet.beginGap, diag + scoreSet.getScore(qryChars[i], refChars[j3]))) : Math.max(Sp[j3] + PairwiseAlignment.scoreSet.gap, Math.max(right + PairwiseAlignment.scoreSet.gap, diag + scoreSet.getScore(qryChars[i], refChars[j3])))));
                    diag = Sp[j3];
                    PairwiseAlignment.Sp[j3] = right;
                }
            }
            int maxValue = Sn[j1] + Sp[j1];
            int maxJ = j1;
            for (int j4 = j1 + 1; j4 <= j2; ++j4) {
                if (Sn[j4] + Sp[j4] < maxValue) continue;
                maxValue = Sn[j4] + Sp[j4];
                maxJ = j4;
            }
            PairwiseAlignment.path(i1, j1, middle, maxJ);
            PairwiseAlignment.path(middle, maxJ, i2, j2);
        }
    }

    public static String getAlignedQuery() {
        return alignedQueryString;
    }

    public static String getAlignedReference() {
        return alignedReferenceString;
    }

    static {
        alignedQueryString = null;
        alignedReferenceString = null;
        score = 0;
    }
}

