/*
 * Decompiled with CFR 0.152.
 */
package AlignmentTools;

import java.util.ArrayList;
import java.util.List;

public class MultipleAlignment {
    private static final int MATCH_SCORE = 1;
    private static final int MISMATCH_SCORE = -2;
    private static final int GAP_PENALTY = -1;

    public List<String> run(List<String> sequences) {
        ArrayList<String> alignedSequences = new ArrayList<String>(sequences);
        AlignmentResult result = null;
        while (alignedSequences.size() > 1) {
            int maxScore = Integer.MIN_VALUE;
            int maxI = 0;
            int maxJ = 0;
            for (int i = 0; i < alignedSequences.size(); ++i) {
                for (int j = i + 1; j < alignedSequences.size(); ++j) {
                    result = this.pairwiseAlignment((String)alignedSequences.get(i), (String)alignedSequences.get(j));
                    if (result.score <= maxScore) continue;
                    maxScore = result.score;
                    maxI = i;
                    maxJ = j;
                }
            }
            int initialSize = alignedSequences.size();
            alignedSequences.set(maxI, result.align1);
            alignedSequences.set(maxJ, result.align2);
            for (int k = maxJ; k < alignedSequences.size() - 1; ++k) {
                alignedSequences.remove(k + 1);
            }
            if (initialSize != alignedSequences.size()) continue;
            break;
        }
        return alignedSequences;
    }

    private AlignmentResult pairwiseAlignment(String seq1, String seq2) {
        int i;
        int[][] scoreMatrix = new int[seq1.length() + 1][seq2.length() + 1];
        for (i = 0; i <= seq1.length(); ++i) {
            scoreMatrix[i][0] = -1 * i;
        }
        for (int j = 0; j <= seq2.length(); ++j) {
            scoreMatrix[0][j] = -1 * j;
        }
        for (i = 1; i <= seq1.length(); ++i) {
            for (int j = 1; j <= seq2.length(); ++j) {
                int match = scoreMatrix[i - 1][j - 1] + (seq1.charAt(i - 1) == seq2.charAt(j - 1) ? 1 : -2);
                int delete = scoreMatrix[i - 1][j] + -1;
                int insert = scoreMatrix[i][j - 1] + -1;
                scoreMatrix[i][j] = Math.max(match, Math.max(delete, insert));
            }
        }
        StringBuilder align1 = new StringBuilder();
        StringBuilder align2 = new StringBuilder();
        int i2 = seq1.length();
        int j = seq2.length();
        while (i2 > 0 || j > 0) {
            if (i2 > 0 && j > 0 && scoreMatrix[i2][j] == scoreMatrix[i2 - 1][j - 1] + (seq1.charAt(i2 - 1) == seq2.charAt(j - 1) ? 1 : -2)) {
                align1.append(seq1.charAt(--i2));
                align2.append(seq2.charAt(--j));
                continue;
            }
            if (i2 > 0 && scoreMatrix[i2][j] == scoreMatrix[i2 - 1][j] + -1) {
                align1.append(seq1.charAt(--i2));
                align2.append("-");
                continue;
            }
            align1.append("-");
            align2.append(seq2.charAt(--j));
        }
        return new AlignmentResult(scoreMatrix[seq1.length()][seq2.length()], align1.reverse().toString(), align2.reverse().toString());
    }

    private class AlignmentResult {
        public final int score;
        public final String align1;
        public final String align2;

        public AlignmentResult(int score, String align1, String align2) {
            this.score = score;
            this.align1 = align1;
            this.align2 = align2;
        }
    }
}

