/*
 * Decompiled with CFR 0.152.
 */
package AlignmentTools;

import java.util.ArrayList;

public class BLAST {
    private static final int MATCH = 2;
    private static final int MISMATCH = -1;
    private static final int GAP = -2;
    private static final int HSP_LENGTH = 3;

    public static void main(String[] args) {
        String[] subjects;
        String query = "AGCAT";
        for (String subject : subjects = new String[]{"GAC", "AGCATGAC", "GACAGCAT"}) {
            ArrayList<HighScoringPair> hsps = new ArrayList<HighScoringPair>();
            for (int i = 0; i <= subject.length() - 3; ++i) {
                String subSubject = subject.substring(i, i + 3);
                int[][] dp = new int[query.length() + 1][subSubject.length() + 1];
                for (int j = 1; j <= query.length(); ++j) {
                    for (int k = 1; k <= subSubject.length(); ++k) {
                        int match = dp[j - 1][k - 1] + (query.charAt(j - 1) == subSubject.charAt(k - 1) ? 2 : -1);
                        int delete = dp[j - 1][k] + -2;
                        int insert = dp[j][k - 1] + -2;
                        dp[j][k] = Math.max(0, Math.max(match, Math.max(delete, insert)));
                    }
                }
                int maxValue = 0;
                int maxI = 0;
                int maxJ = 0;
                for (int j = 1; j <= query.length(); ++j) {
                    for (int k = 1; k <= subSubject.length(); ++k) {
                        if (dp[j][k] <= maxValue) continue;
                        maxValue = dp[j][k];
                        maxI = j;
                        maxJ = k;
                    }
                }
                if (maxValue <= 0) continue;
                hsps.add(new HighScoringPair(i, maxValue, BLAST.getAlignment(query, subSubject, dp, maxI, maxJ)));
            }
        }
    }

    private static String[] getAlignment(String query, String subject, int[][] dp, int maxI, int maxJ) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        while (maxI > 0 && maxJ > 0) {
            if (dp[maxI][maxJ] == dp[maxI - 1][maxJ - 1] + (query.charAt(maxI - 1) == subject.charAt(maxJ - 1) ? 2 : -1)) {
                sb1.append(query.charAt(maxI - 1));
                sb2.append(subject.charAt(maxJ - 1));
                --maxI;
                --maxJ;
                continue;
            }
            if (dp[maxI][maxJ] == dp[maxI - 1][maxJ] + -2) {
                sb1.append(query.charAt(maxI - 1));
                sb2.append("-");
                --maxI;
                continue;
            }
            sb1.append("-");
            sb2.append(subject.charAt(maxJ - 1));
            --maxJ;
        }
        return new String[]{sb1.reverse().toString(), sb2.reverse().toString()};
    }

    private static class HighScoringPair {
        int start;
        int score;
        String[] alignment;

        public HighScoringPair(int start, int score, String[] alignment) {
            this.start = start;
            this.score = score;
            this.alignment = alignment;
        }

        public String toString() {
            return "Start: " + this.start + ", Score: " + this.score + "\nAlignment 1: " + this.alignment[0] + "\nAlignment 2: " + this.alignment[1];
        }
    }
}

