/*
 * Decompiled with CFR 0.152.
 */
package AbstractClasses;

import GenbankFileReader.Locus;
import SequenceEditorPanels.ExtensibleArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractGappedFinder {
    protected String sequence;
    protected int searchLimit = 0;
    protected boolean isCircular = false;
    protected boolean isCaseSensitive = false;
    protected boolean isSearchSense = true;
    protected boolean isSearchAntiSense = true;
    protected boolean allowDegenerate = false;
    protected String gap = "-";
    protected final ExtensibleArray<Locus> matches = new ExtensibleArray<Locus>(Locus.class);
    protected final ExtensibleArray<Locus> tmpMatches = new ExtensibleArray<Locus>(Locus.class);

    public abstract String stringToDegenerate(String var1);

    public void setGapString(String gap) {
        if (gap != null && gap.length() > 0) {
            this.gap = gap;
        }
    }

    public String getGapChar() {
        return this.gap;
    }

    public boolean isSearchSense() {
        return this.isSearchSense;
    }

    public boolean isSearchAntiSense() {
        return this.isSearchAntiSense;
    }

    public void setSearchSense(boolean search) {
        this.isSearchSense = search;
    }

    public void isSearchAntiSense(boolean search) {
        this.isSearchAntiSense = search;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public boolean isAllowedDegenerate() {
        return this.allowDegenerate;
    }

    public void setAllowDegenerate(boolean isDegenerate) {
        this.allowDegenerate = isDegenerate;
    }

    public int getMatchCount() {
        return this.matches.size();
    }

    public Locus[] getMatches() {
        return this.matches.isEmpty() ? null : this.matches.toArray();
    }

    public void clear() {
        this.matches.clear();
    }

    public AbstractGappedFinder() {
    }

    public AbstractGappedFinder(String sequence) {
        this(sequence, false);
    }

    public AbstractGappedFinder(String sequence, boolean circular) {
        this(sequence, circular, false);
    }

    public AbstractGappedFinder(String sequence, boolean circular, boolean caseSensitive) {
        this.isCircular = circular;
        this.isCaseSensitive = caseSensitive;
        this.searchLimit = sequence.length();
        if (!this.isCaseSensitive) {
            sequence = sequence.toUpperCase();
        }
        this.sequence = circular ? sequence + sequence : sequence;
    }

    public abstract boolean find(String var1, boolean var2, boolean var3);

    public boolean find(String qry) {
        return this.find(qry, this.isSearchSense, this.isSearchAntiSense);
    }

    protected Locus[] findOnStrand(String ref, String qry) {
        int qryLen = qry.length();
        if (qryLen < 3) {
            return null;
        }
        qry = this.trimEndGaps(qry);
        if (!this.isCaseSensitive) {
            qry = qry.toUpperCase();
        }
        this.tmpMatches.clear();
        if (!qry.contains("-")) {
            Node ungapped = this.findUngappedQuery(ref, qry);
            if (ungapped == null) {
                return null;
            }
            Node cNode = ungapped;
            while (cNode != null) {
                this.tmpMatches.add(cNode.locus);
                cNode = cNode.next;
            }
        } else {
            String[] searchStrings = qry.split(this.gap);
            Node firstNode = this.findUngappedQuery(ref, searchStrings[0]);
            if (firstNode == null) {
                return null;
            }
            int firstIndex = firstNode.getFirst().locus.getStop() + 1;
            Node lastNode = this.findUngappedQuery(ref, searchStrings[searchStrings.length - 1], firstIndex);
            if (lastNode == null) {
                return null;
            }
            int lastIndex = lastNode.getLast().locus.getStart();
            Node[] fragments = new Node[searchStrings.length - 2];
            for (int x = 1; x < searchStrings.length - 1; ++x) {
                if (searchStrings[x].length() <= 0) continue;
                Node node = this.findUngappedQuery(ref, searchStrings[x], firstIndex, lastIndex - searchStrings[x].length());
                if (node == null) {
                    return null;
                }
                firstIndex = node.getFirst().locus.getStop();
                fragments[x - 1] = node;
            }
            Node startNode = firstNode;
            while (startNode != null) {
                int start = startNode.locus.getStart();
                Node endNode = lastNode;
                while (endNode != null) {
                    int stop = endNode.locus.getStart();
                    if (this.haveFrags(start, stop, fragments)) {
                        this.tmpMatches.add(new Locus(start, endNode.locus.getStop()));
                    }
                    endNode = endNode.next;
                }
                startNode = startNode.next;
            }
        }
        return this.tmpMatches.toArray();
    }

    private Node findUngappedQuery(String ref, String query) {
        return this.findUngappedQuery(ref, query, 0, this.searchLimit);
    }

    private Node findUngappedQuery(String ref, String query, int start) {
        return this.findUngappedQuery(ref, query, start, this.searchLimit);
    }

    private Node findUngappedQuery(String ref, String query, int start, int end) {
        String degenQuery;
        if (this.allowDegenerate && !(degenQuery = this.stringToDegenerate(query)).equalsIgnoreCase(query)) {
            return this.findUngappedDegenQuery(ref, degenQuery, start, end);
        }
        int index = ref.indexOf(query, start);
        Node retVal = null;
        Node cNode = null;
        while (index > -1 && index < end) {
            Node newNode = new Node(index + 1, index + query.length());
            if (retVal == null) {
                retVal = newNode;
                cNode = newNode;
            } else {
                cNode.next = newNode;
                cNode = newNode;
            }
            ++index;
            index = ref.indexOf(query, index);
        }
        return retVal;
    }

    private Node findUngappedDegenQuery(String ref, String degenQuery, int start, int end) {
        Pattern patternDNA = Pattern.compile(degenQuery, 2);
        Matcher matcher = patternDNA.matcher(ref);
        Node retVal = null;
        Node cNode = null;
        while (matcher.find(start) && matcher.start() < end) {
            Node newNode = new Node(matcher.start() + 1, matcher.end());
            if (retVal == null) {
                retVal = newNode;
                cNode = newNode;
            } else {
                cNode.next = newNode;
                cNode = newNode;
            }
            start = newNode.locus.getStart();
        }
        return retVal;
    }

    private boolean haveFrags(int start, int stop, Node[] fragments) {
        if (start >= stop) {
            return false;
        }
        int prevFragEnd = start;
        boolean valid = false;
        for (int midIndex = 0; midIndex < fragments.length; ++midIndex) {
            valid = false;
            Node fNode = fragments[midIndex];
            while (fNode != null) {
                if (fNode.locus.getStart() > prevFragEnd && fNode.locus.getStop() < stop) {
                    prevFragEnd = fNode.locus.getStop();
                    valid = true;
                    break;
                }
                fNode = fNode.next;
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    private String trimEndGaps(String qry) {
        int x;
        int first = -1;
        int last = -1;
        for (x = 0; x < qry.length(); ++x) {
            if (qry.charAt(x) == '-') continue;
            first = x;
            break;
        }
        if (first == -1) {
            return "";
        }
        for (x = qry.length() - 1; x >= first; --x) {
            if (qry.charAt(x) == '-') continue;
            last = x;
            break;
        }
        if (last == -1) {
            return "";
        }
        if (first > -1 && last == -1) {
            return qry.substring(first);
        }
        if (first == -1 && last > -1) {
            return qry.substring(0, last + 1);
        }
        if (first > -1 && last > -1) {
            return qry.substring(first, last + 1);
        }
        return qry;
    }

    private class Node {
        Locus locus;
        Node previous = null;
        Node next = null;

        Node(int start, int stop) {
            this.locus = new Locus(start, stop);
        }

        public boolean hasPrevious() {
            return this.previous == null;
        }

        public boolean hasNext() {
            return this.next == null;
        }

        public Locus toLocus() {
            Locus retVal = new Locus(this.locus.getStart(), this.locus.getStop(), false, AbstractGappedFinder.this.searchLimit);
            return retVal;
        }

        public Node getFirst() {
            Node node = this;
            while (node.previous != null) {
                node = node.previous;
            }
            return node;
        }

        public Node getLast() {
            Node node = this;
            while (node.next != null) {
                node = node.next;
            }
            return node;
        }
    }
}

