/*
 * Decompiled with CFR 0.152.
 */
package AboutWindow;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.JavaBean;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

@JavaBean(defaultProperty="UIClassID", description="A generic About dialog window that displays information provided by the user pertaining to their app.")
public class AboutForm
extends JDialog
implements KeyListener {
    String appName = "AppName";
    String version = "VersionNumber";
    String copyright = "CopyrightInfo";
    private final Cursor handCursor = new Cursor(12);
    private final Cursor defaultCursor = new Cursor(0);
    Color mouseOverColor = Color.red;
    Color mouseDownColor = Color.orange;
    Color mouseOutColor = Color.blue;
    ImageIcon icon = null;
    Image iconImage = null;
    private JButton cmdClose;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblCopyright;
    private JLabel lblName;
    private JLabel lblVersion;
    private JPanel linkPanel;

    public AboutForm(Frame parent, boolean modal) {
        super(parent, modal);
        this.initForm(parent);
    }

    public AboutForm(Frame parent, boolean modal, String appName, String version, String copyright, String url1, String url2, ImageIcon icon) {
        super(parent, modal);
        this.initForm(parent);
        this.setInformation(appName, version, copyright, null, url1, null, url2, icon);
    }

    private void initForm(Frame parent) {
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.addKeyListener(this);
        this.cmdClose.addKeyListener(this);
    }

    public void setInformation(String appName, String version, String copyright, String url1, String url2, ImageIcon icon) {
        this.setInformation(appName, version, copyright, null, url1, null, url2, icon);
    }

    public void setInformation(String appName, String version, String copyright, String url1Title, String url1, String url2Title, String url2, ImageIcon icon) {
        if (appName != null) {
            this.setAppName(appName);
        }
        if (version != null) {
            this.setVersion(version);
        }
        if (copyright != null) {
            this.setCopyright(copyright);
        }
        if (url1 != null) {
            this.addLinkLabel(url1Title, url1);
        }
        if (url2 != null) {
            this.addLinkLabel(url2Title, url2);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public JLabel addLabel(String labelText) {
        JLabel label = new JLabel(labelText);
        this.linkPanel.add(label);
        this.linkPanel.setLayout(new GridLayout(this.linkPanel.getComponentCount(), 0, 1, 1));
        this.pack();
        return label;
    }

    public JLabel addLinkLabel(String labelText, String linkURL) {
        LinkLabel label = new LinkLabel(labelText, linkURL);
        this.linkPanel.add(label);
        this.linkPanel.setLayout(new GridLayout(this.linkPanel.getComponentCount(), 0, 1, 1));
        this.pack();
        return label;
    }

    public void setAppName(String appName) {
        this.lblName.setText(appName);
        this.setTitle("About " + appName);
    }

    public void setVersion(String version) {
        this.lblVersion.setText(version);
    }

    public void setCopyright(String copyright) {
        this.lblCopyright.setText(copyright);
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
        this.iconImage = icon.getImage();
        this.setIconImage(this.iconImage);
    }

    public String getAppName() {
        return this.lblName.getText();
    }

    public String getVersion() {
        return this.lblVersion.getText();
    }

    public String getCopyright() {
        return this.lblCopyright.getText();
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (AboutForm.this.iconImage != null) {
                    g.drawImage(AboutForm.this.iconImage, 0, 0, this);
                }
            }
        };
        this.linkPanel = new JPanel();
        this.lblName = new JLabel();
        this.lblVersion = new JLabel();
        this.lblCopyright = new JLabel();
        this.jPanel2 = new JPanel();
        this.cmdClose = new JButton();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.jPanel1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 64, Short.MAX_VALUE));
        this.linkPanel.setOpaque(false);
        this.linkPanel.setLayout(new GridLayout(5, 0));
        this.lblName.setFont(new Font("Segoe UI", 3, 24));
        this.lblName.setText("AppName");
        this.linkPanel.add(this.lblName);
        this.lblVersion.setText("VersionNumber");
        this.linkPanel.add(this.lblVersion);
        this.lblCopyright.setText("CopyrightInfo");
        this.linkPanel.add(this.lblCopyright);
        this.jPanel2.setOpaque(false);
        this.cmdClose.setText("Close");
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutForm.this.cmdCloseActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.cmdClose, -2, 81, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cmdClose).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.linkPanel, -2, 446, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.linkPanel, -1, -1, Short.MAX_VALUE)).addGap(49, 49, 49).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AboutForm dialog = new AboutForm((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
            this.dispose();
        }
    }

    class LinkLabel
    extends JLabel {
        String url;
        MouseListener urlLabelListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (LinkLabel.this.haveURL()) {
                    LinkLabel.this.setForeground(AboutForm.this.mouseDownColor);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (LinkLabel.this.url == null || LinkLabel.this.url.length() == 0) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                if (x >= 0 && x <= LinkLabel.this.getWidth() && y > 0 && y <= LinkLabel.this.getHeight()) {
                    LinkLabel.this.setForeground(AboutForm.this.mouseOverColor);
                    if (LinkLabel.this.haveURL()) {
                        this.openURL(LinkLabel.this.url);
                    }
                }
            }

            private void openURL(String url) {
                try {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(AboutForm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (LinkLabel.this.haveURL()) {
                    LinkLabel.this.setForeground(AboutForm.this.mouseOverColor);
                    LinkLabel.this.setCursor(AboutForm.this.handCursor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (LinkLabel.this.haveURL()) {
                    LinkLabel.this.setForeground(AboutForm.this.mouseOutColor);
                    LinkLabel.this.setCursor(AboutForm.this.defaultCursor);
                }
            }
        };

        private boolean haveURL() {
            return this.url != null && this.url.length() > 0;
        }

        public LinkLabel() {
        }

        public LinkLabel(String text) {
            this.setText(text);
        }

        public LinkLabel(String text, String url) {
            this.setText(text);
            this.setURL(url);
        }

        public void setURL(String url) {
            this.url = url;
            this.update();
        }

        private void update() {
            if (this.url.length() > 0) {
                this.setCursor(AboutForm.this.handCursor);
                this.addMouseListener(this.urlLabelListener);
                this.setForeground(AboutForm.this.mouseOutColor);
            } else {
                this.setCursor(AboutForm.this.defaultCursor);
                this.removeMouseListener(this.urlLabelListener);
            }
        }
    }
}

