/*
 * Decompiled with CFR 0.152.
 */
package AbiFileReader;

import AbiFileReader.TOCEntry;
import java.io.IOException;
import java.io.RandomAccessFile;

class ABIHeader
extends TOCEntry {
    public static final byte[] HEADERBYTES = new byte[]{65, 66, 73, 70, 0, 101, 116, 100, 105, 114, 0, 0, 0, 1, 3, -1, 28};
    public byte[] headerBytes = new byte[6];

    ABIHeader() {
    }

    public void write() {
    }

    public boolean isValid() {
        return this.headerBytes[0] == 65 && this.headerBytes[1] == 66 && this.headerBytes[2] == 73 && this.headerBytes[3] == 70 && this.headerBytes[4] == 0 && this.headerBytes[5] == 101 && this.tagName.equals("tdir");
    }

    public static ABIHeader readHeader(RandomAccessFile inStream) {
        ABIHeader dir = new ABIHeader();
        try {
            inStream.read(dir.headerBytes);
            byte[] tagName = new byte[4];
            inStream.read(tagName);
            dir.tagName = new String(tagName);
            dir.tagNum = inStream.readInt();
            dir.elementType = inStream.readShort();
            dir.elementSize = inStream.readShort();
            dir.numElements = inStream.readInt();
            dir.dataSize = inStream.readInt();
            dir.dataOffset = inStream.readInt();
            dir.data = new byte[dir.dataSize];
            long cOffset = inStream.getFilePointer();
            inStream.seek(dir.dataOffset);
            inStream.read(dir.data);
            inStream.seek(cOffset + 94L);
            dir.dataHandle = inStream.readInt();
        }
        catch (IOException ex) {
            return null;
        }
        return dir;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[108];
        int index = 0;
        System.arraycopy(HEADERBYTES, 0, bytes, index, HEADERBYTES.length);
        index += HEADERBYTES.length;
        return bytes;
    }
}

