/*
 * Decompiled with CFR 0.152.
 */
package SeqTools;

import BioDocumentFilters.BioAllowedKeyFilter;
import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DNATools.MutationAnnotation;
import ProteinTools.AminoAcid;
import ProteinTools.CodonTable;
import SeqTools.SeqMutator;
import SeqTools.SequenceMutator;
import Sequences.DNA;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;

class FrmMutator
extends JDialog {
    private SeqMutator tester;
    private final AnnotationListModel listModel = new AnnotationListModel();
    ImageIcon plus = SequenceMutator.plus;
    ImageIcon first = SequenceMutator.first;
    ImageIcon last = SequenceMutator.last;
    ImageIcon up = SequenceMutator.up;
    ImageIcon down = SequenceMutator.down;
    ImageIcon xred = SequenceMutator.xred;
    ImageIcon question = SequenceMutator.question;
    private String helpText = "<html><b>Enter each annotation on a separate line or combine multiple changes  in one oligo set by placing<br>the annotations on the same line separated by spaces, commas or plus<br>&nbsp;Ex (DNA):</b><br>&nbsp;&nbsp;c.C1234T<br>&nbsp;&nbsp;c.C1234T&nbsp;+&nbsp;c.G1235A<br>&nbsp;&nbsp;c.C1234T,&nbsp;c.G1235A<br>&nbsp;&nbsp;c.C1234T&nbsp;c.G1235A<br>&nbsp;&nbsp;c.1234C>T<br>&nbsp;&nbsp;c.20dupC<br>&nbsp;&nbsp;c.16_17delAG<br>&nbsp;&nbsp;c.16delA<br>&nbsp;&nbsp;c.16A>del<br>&nbsp;&nbsp;c.A16del<br>&nbsp;&nbsp;1234C>T<br><br><b>&nbsp;Ex (Protein):</b><br>&nbsp;&nbsp;p.Ala123Glu<br>&nbsp;&nbsp;p.Ala123Glu&nbsp;+&nbsp;p.Pro124Tyr<br>&nbsp;&nbsp;p.A123G<br>&nbsp;&nbsp;p.Ala5del<br>&nbsp;&nbsp;Ala123Glu</html>";
    KeyListener kl = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (e.getComponent() == FrmMutator.this.txtCodonNum || e.getComponent() == FrmMutator.this.cmbAA) {
                    FrmMutator.this.validateValues();
                    FrmMutator.this.addAAMutation();
                } else if (e.getComponent() == FrmMutator.this.txtDNANum || e.getComponent() == FrmMutator.this.cmbDNA) {
                    FrmMutator.this.validateValues();
                    FrmMutator.this.addDNAMutation();
                }
            }
        }
    };
    FocusListener fl = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getComponent() == FrmMutator.this.txtCodonNum || e.getComponent() == FrmMutator.this.cmbAA) {
                FrmMutator.this.validateValues();
            } else if (e.getComponent() == FrmMutator.this.txtDNANum || e.getComponent() == FrmMutator.this.cmbDNA) {
                FrmMutator.this.validateValues();
            }
        }
    };
    private String oSeq;
    private JComboBox<AAListItem> cmbAA;
    private JComboBox<String> cmbDNA;
    private JComboBox<String> cmbOrg;
    private GlossyButton cmdAddBatch;
    private GlossyButton cmdAddBp;
    private GlossyButton cmdAddCodon;
    private GlossyButton cmdDelete;
    private GlossyButton cmdDelete1;
    private GlossyButton cmdDown;
    private GlossyButton cmdFirst;
    private GlossyButton cmdLast;
    private GlossyButton cmdUp;
    private ButtonGroup grpCodonType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblBatchHelp;
    private JLabel lblOrganism;
    private JList<MutationAnnotation> lstMutations;
    private JRadioButton opHighest;
    private JRadioButton opNearest;
    private JTabbedPane tabbedPane;
    private JTextPane txtBatchMutations;
    private JTextField txtCodonNum;
    private JTextField txtDNANum;
    private JTextArea txtMutatedSeq;
    private JTextField txtOrigAA;
    private JTextField txtOrigDNA;

    private void addLog(String text) {
        JOptionPane.showMessageDialog(this, text, "Error", 0);
    }

    public void setSequence(String seq) {
        this.oSeq = seq.toLowerCase();
        this.tester = new SeqMutator(this.oSeq){

            @Override
            void logError(String text) {
                FrmMutator.this.addLog(text);
            }
        };
        this.txtMutatedSeq.setText(this.oSeq);
        this.txtMutatedSeq.select(0, 0);
        this.validateValues();
    }

    public String getSequence() {
        return this.oSeq;
    }

    private void validateValues() {
        if (this.oSeq == null) {
            return;
        }
        int codon = Integer.parseInt(this.txtCodonNum.getText());
        if (codon < 0) {
            codon = 1;
        } else if (codon > this.oSeq.length() / 3) {
            codon = this.oSeq.length() / 3;
        }
        this.txtCodonNum.setText("" + codon);
        int codonStart = DNA.codonNumberToBpStart((int)codon);
        if (codonStart > 0 && codonStart + 3 < this.oSeq.length()) {
            this.txtOrigAA.setText(CodonTable.translateCodon((char)this.oSeq.charAt(codonStart - 1), (char)this.oSeq.charAt(codonStart), (char)this.oSeq.charAt(codonStart + 1), (int)10).getAbbr3());
        } else {
            this.txtOrigAA.setText("Xxx");
        }
        int bp = Integer.parseInt(this.txtDNANum.getText());
        if (bp < 0) {
            bp = 1;
        } else if (bp > this.oSeq.length()) {
            bp = this.oSeq.length();
        }
        this.txtDNANum.setText("" + bp);
        this.txtOrigDNA.setText(this.oSeq.substring(bp - 1, bp));
    }

    public FrmMutator(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.txtCodonNum.addKeyListener(this.kl);
        this.cmbAA.addKeyListener(this.kl);
        this.txtDNANum.addKeyListener(this.kl);
        this.cmbDNA.addKeyListener(this.kl);
        this.txtCodonNum.addFocusListener(this.fl);
        this.cmbAA.addFocusListener(this.fl);
        this.txtDNANum.addFocusListener(this.fl);
        this.cmbDNA.addFocusListener(this.fl);
        this.lblBatchHelp.setToolTipText(this.helpText);
        BioAllowedKeyFilter numFilter = new BioAllowedKeyFilter("1234567890");
        ((AbstractDocument)this.txtCodonNum.getDocument()).setDocumentFilter((DocumentFilter)numFilter);
        ((AbstractDocument)this.txtDNANum.getDocument()).setDocumentFilter((DocumentFilter)numFilter);
        String cancelName = "cancel";
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmMutator.this.dispose();
            }
        });
        for (int x = 0; x < AminoAcid.NAMES.length; ++x) {
            this.cmbAA.addItem(new AAListItem(AminoAcid.Abbr1[x], AminoAcid.Abbr3[x], AminoAcid.NAMES[x]));
        }
        int count = CodonTable.getOrganismCount();
        this.cmbOrg.removeAllItems();
        for (int x = 0; x < count; ++x) {
            this.cmbOrg.addItem(CodonTable.getOrganismName((int)x));
        }
    }

    private void mutate() {
        if (this.listModel.getSize() > 0) {
            SeqMutator sm = new SeqMutator(this.oSeq){

                @Override
                void logError(String text) {
                    FrmMutator.this.addLog(text);
                }
            };
            sm.setCodonChoice(this.opHighest.isSelected() ? 1 : 0);
            sm.codonTable.setOrganism((String)this.cmbOrg.getSelectedItem());
            for (MutationAnnotation m : this.listModel.mutations) {
                sm.addMutation(m);
            }
            String ms = sm.mutateSequence();
            this.txtMutatedSeq.setText(ms != null ? ms : "");
        } else {
            this.txtMutatedSeq.setText(this.oSeq);
        }
        this.txtMutatedSeq.select(0, 0);
        this.validateValues();
    }

    private void initComponents() {
        this.grpCodonType = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.lstMutations = new JList();
        this.tabbedPane = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.txtCodonNum = new JTextField();
        this.jLabel1 = new JLabel();
        this.txtOrigAA = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cmdAddCodon = new GlossyButton();
        this.cmbAA = new JComboBox();
        this.lblOrganism = new JLabel();
        this.cmbOrg = new JComboBox();
        this.opHighest = new JRadioButton();
        this.opNearest = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.txtDNANum = new JTextField();
        this.jLabel4 = new JLabel();
        this.txtOrigDNA = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.cmdAddBp = new GlossyButton();
        this.cmbDNA = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.txtBatchMutations = new JTextPane();
        this.lblBatchHelp = new JLabel();
        this.cmdAddBatch = new GlossyButton();
        this.jScrollPane2 = new JScrollPane();
        this.txtMutatedSeq = new JTextArea();
        this.jPanel4 = new JPanel();
        this.cmdFirst = new GlossyButton();
        this.cmdUp = new GlossyButton();
        this.cmdDown = new GlossyButton();
        this.cmdLast = new GlossyButton();
        this.cmdDelete = new GlossyButton();
        this.cmdDelete1 = new GlossyButton();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder("Mutations"));
        this.lstMutations.setBorder(null);
        this.lstMutations.setModel(this.listModel);
        this.jScrollPane1.setViewportView(this.lstMutations);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Mutate by Codon Number"));
        this.txtCodonNum.setHorizontalAlignment(0);
        this.txtCodonNum.setText("1");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Codon");
        this.txtOrigAA.setEditable(false);
        this.txtOrigAA.setHorizontalAlignment(0);
        this.txtOrigAA.setText("Arg");
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Current");
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("New");
        this.cmdAddCodon.setBackground(new Color(0, 255, 0));
        this.cmdAddCodon.setIcon((Icon)this.plus);
        this.cmdAddCodon.setText("Add");
        this.cmdAddCodon.setToolTipText("Add mutation");
        this.cmdAddCodon.setColorHot(new Color(51, 204, 0));
        this.cmdAddCodon.setColorNormal(new Color(0, 255, 0));
        this.cmdAddCodon.setColorPressed(new Color(51, 204, 0));
        this.cmdAddCodon.setDoubleBuffered(true);
        this.cmdAddCodon.setFocusPainted(true);
        this.cmdAddCodon.setFont(new Font("Tahoma", 1, 12));
        this.cmdAddCodon.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdAddCodon.setMaximumSize(new Dimension(79, 22));
        this.cmdAddCodon.setMinimumSize(new Dimension(79, 22));
        this.cmdAddCodon.setPreferredSize(new Dimension(79, 22));
        this.cmdAddCodon.setShiftOnPress(true);
        this.cmdAddCodon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdAddCodonActionPerformed(evt);
            }
        });
        this.cmbAA.setModel(new DefaultComboBoxModel<AAListItem>(new AAListItem[0]));
        this.lblOrganism.setText("Organism");
        this.cmbOrg.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.grpCodonType.add(this.opHighest);
        this.opHighest.setSelected(true);
        this.opHighest.setText("Use highest codon frequency");
        this.grpCodonType.add(this.opNearest);
        this.opNearest.setText("Use nearest codon");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.txtOrigAA, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.txtCodonNum, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.cmbAA, 0, 124, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblOrganism).addGap(18, 18, 18).addComponent(this.cmbOrg, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdAddCodon, -2, 98, -2).addGap(7, 7, 7)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.opHighest).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.opNearest).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.txtOrigAA, -2, -1, -2).addComponent(this.txtCodonNum, -2, -1, -2).addComponent((Component)this.cmdAddCodon, -2, 33, -2).addComponent(this.cmbAA, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblOrganism).addComponent(this.cmbOrg, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.opHighest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.opNearest).addContainerGap(55, Short.MAX_VALUE)));
        this.tabbedPane.addTab("By Codon", this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Mutate by DNA Position"));
        this.txtDNANum.setHorizontalAlignment(0);
        this.txtDNANum.setText("1");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Bp");
        this.txtOrigDNA.setEditable(false);
        this.txtOrigDNA.setHorizontalAlignment(0);
        this.txtOrigDNA.setText("T");
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("Current");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("New");
        this.cmdAddBp.setBackground(new Color(0, 255, 0));
        this.cmdAddBp.setIcon((Icon)this.plus);
        this.cmdAddBp.setText("Add");
        this.cmdAddBp.setToolTipText("Add mutation");
        this.cmdAddBp.setColorHot(new Color(51, 204, 0));
        this.cmdAddBp.setColorNormal(new Color(0, 255, 0));
        this.cmdAddBp.setColorPressed(new Color(51, 204, 0));
        this.cmdAddBp.setDoubleBuffered(true);
        this.cmdAddBp.setFocusPainted(true);
        this.cmdAddBp.setFont(new Font("Tahoma", 1, 12));
        this.cmdAddBp.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdAddBp.setMaximumSize(new Dimension(79, 22));
        this.cmdAddBp.setMinimumSize(new Dimension(79, 22));
        this.cmdAddBp.setPreferredSize(new Dimension(79, 22));
        this.cmdAddBp.setShiftOnPress(true);
        this.cmdAddBp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdAddBpActionPerformed(evt);
            }
        });
        this.cmbDNA.setModel(new DefaultComboBoxModel<String>(new String[]{"A", "C", "G", "T"}));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cmbDNA, -2, 71, -2).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE).addComponent(this.txtOrigDNA, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.txtDNANum, -2, 71, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6, -2, 71, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdAddBp, -2, -1, -2).addContainerGap(79, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.txtOrigDNA, -2, -1, -2).addComponent(this.txtDNANum, -2, -1, -2).addComponent((Component)this.cmdAddBp, -2, 33, -2).addComponent(this.cmbDNA, -2, -1, -2)).addContainerGap(155, Short.MAX_VALUE)));
        this.tabbedPane.addTab("By Bp Number", this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Batch Mutations"));
        this.jScrollPane3.setViewportView(this.txtBatchMutations);
        this.lblBatchHelp.setHorizontalAlignment(0);
        this.lblBatchHelp.setIcon(this.question);
        this.cmdAddBatch.setBackground(new Color(0, 255, 0));
        this.cmdAddBatch.setIcon((Icon)this.plus);
        this.cmdAddBatch.setText("Add");
        this.cmdAddBatch.setToolTipText("Add mutation");
        this.cmdAddBatch.setColorHot(new Color(51, 204, 0));
        this.cmdAddBatch.setColorNormal(new Color(0, 255, 0));
        this.cmdAddBatch.setColorPressed(new Color(51, 204, 0));
        this.cmdAddBatch.setDoubleBuffered(true);
        this.cmdAddBatch.setFocusPainted(true);
        this.cmdAddBatch.setFont(new Font("Tahoma", 1, 12));
        this.cmdAddBatch.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdAddBatch.setMaximumSize(new Dimension(79, 22));
        this.cmdAddBatch.setMinimumSize(new Dimension(79, 22));
        this.cmdAddBatch.setPreferredSize(new Dimension(79, 22));
        this.cmdAddBatch.setShiftOnPress(true);
        this.cmdAddBatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdAddBatchActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 272, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.lblBatchHelp, -2, 32, -2).addContainerGap(67, Short.MAX_VALUE)).addComponent((Component)this.cmdAddBatch, GroupLayout.Alignment.TRAILING, -2, -1, -2))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -2, 204, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent((Component)this.cmdAddBatch, -2, 33, -2).addGap(8, 8, 8).addComponent(this.lblBatchHelp, -2, 31, -2))).addContainerGap()));
        this.tabbedPane.addTab("Batch Mode", this.jPanel3);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Mutated Sequence"));
        this.jScrollPane2.setOpaque(false);
        this.txtMutatedSeq.setEditable(false);
        this.txtMutatedSeq.setColumns(20);
        this.txtMutatedSeq.setFont(new Font("Monospaced", 0, 14));
        this.txtMutatedSeq.setLineWrap(true);
        this.txtMutatedSeq.setRows(5);
        this.txtMutatedSeq.setBorder(null);
        this.jScrollPane2.setViewportView(this.txtMutatedSeq);
        this.cmdFirst.setBackground(new Color(153, 153, 255));
        this.cmdFirst.setIcon((Icon)this.first);
        this.cmdFirst.setText("Move to first");
        this.cmdFirst.setToolTipText("Move currently selected ROI to the top of the drawing order.");
        this.cmdFirst.setColorHot(new Color(153, 153, 255));
        this.cmdFirst.setColorNormal(new Color(153, 153, 255));
        this.cmdFirst.setColorPressed(new Color(153, 153, 255));
        this.cmdFirst.setDoubleBuffered(true);
        this.cmdFirst.setFocusPainted(true);
        this.cmdFirst.setFont(new Font("Tahoma", 1, 12));
        this.cmdFirst.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdFirst.setMaximumSize(new Dimension(79, 22));
        this.cmdFirst.setMinimumSize(new Dimension(79, 22));
        this.cmdFirst.setPreferredSize(new Dimension(79, 22));
        this.cmdFirst.setShiftOnPress(true);
        this.cmdFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdFirstActionPerformed(evt);
            }
        });
        this.cmdUp.setBackground(new Color(153, 153, 255));
        this.cmdUp.setIcon((Icon)this.up);
        this.cmdUp.setText("Move up");
        this.cmdUp.setToolTipText("Move currently selected ROI up one in the drawing order.");
        this.cmdUp.setColorHot(new Color(153, 153, 255));
        this.cmdUp.setColorNormal(new Color(153, 153, 255));
        this.cmdUp.setColorPressed(new Color(153, 153, 255));
        this.cmdUp.setDoubleBuffered(true);
        this.cmdUp.setFocusPainted(true);
        this.cmdUp.setFont(new Font("Tahoma", 1, 12));
        this.cmdUp.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdUp.setMaximumSize(new Dimension(79, 22));
        this.cmdUp.setMinimumSize(new Dimension(79, 22));
        this.cmdUp.setPreferredSize(new Dimension(79, 22));
        this.cmdUp.setShiftOnPress(true);
        this.cmdUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdUpActionPerformed(evt);
            }
        });
        this.cmdDown.setBackground(new Color(153, 153, 255));
        this.cmdDown.setIcon((Icon)this.down);
        this.cmdDown.setText("Move down");
        this.cmdDown.setToolTipText("toolTipText\tMove currently selected ROI down one in the drawing order.");
        this.cmdDown.setColorHot(new Color(153, 153, 255));
        this.cmdDown.setColorNormal(new Color(153, 153, 255));
        this.cmdDown.setColorPressed(new Color(153, 153, 255));
        this.cmdDown.setDoubleBuffered(true);
        this.cmdDown.setFocusPainted(true);
        this.cmdDown.setFont(new Font("Tahoma", 1, 12));
        this.cmdDown.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdDown.setMaximumSize(new Dimension(79, 22));
        this.cmdDown.setMinimumSize(new Dimension(79, 22));
        this.cmdDown.setPreferredSize(new Dimension(79, 22));
        this.cmdDown.setShiftOnPress(true);
        this.cmdDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdDownActionPerformed(evt);
            }
        });
        this.cmdLast.setBackground(new Color(153, 153, 255));
        this.cmdLast.setIcon((Icon)this.last);
        this.cmdLast.setText("Move to last");
        this.cmdLast.setToolTipText("Move currently selected ROI to the bottom of the drawing order.");
        this.cmdLast.setColorHot(new Color(153, 153, 255));
        this.cmdLast.setColorNormal(new Color(153, 153, 255));
        this.cmdLast.setColorPressed(new Color(153, 153, 255));
        this.cmdLast.setDoubleBuffered(true);
        this.cmdLast.setFocusPainted(true);
        this.cmdLast.setFont(new Font("Tahoma", 1, 12));
        this.cmdLast.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdLast.setMaximumSize(new Dimension(79, 22));
        this.cmdLast.setMinimumSize(new Dimension(79, 22));
        this.cmdLast.setPreferredSize(new Dimension(79, 22));
        this.cmdLast.setShiftOnPress(true);
        this.cmdLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdLastActionPerformed(evt);
            }
        });
        this.cmdDelete.setBackground(new Color(255, 102, 102));
        this.cmdDelete.setIcon((Icon)this.xred);
        this.cmdDelete.setText("Remove");
        this.cmdDelete.setToolTipText("Delete currently selected ROI(s)");
        this.cmdDelete.setColorHot(new Color(255, 0, 0));
        this.cmdDelete.setColorNormal(new Color(255, 51, 51));
        this.cmdDelete.setColorPressed(new Color(255, 0, 0));
        this.cmdDelete.setDoubleBuffered(true);
        this.cmdDelete.setFocusPainted(true);
        this.cmdDelete.setFont(new Font("Tahoma", 1, 12));
        this.cmdDelete.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdDelete.setShiftOnPress(true);
        this.cmdDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.cmdDelete1.setBackground(new Color(255, 102, 102));
        this.cmdDelete1.setIcon((Icon)this.xred);
        this.cmdDelete1.setText("Remove All");
        this.cmdDelete1.setToolTipText("Delete currently selected ROI(s)");
        this.cmdDelete1.setColorHot(new Color(255, 0, 0));
        this.cmdDelete1.setColorNormal(new Color(255, 51, 51));
        this.cmdDelete1.setColorPressed(new Color(255, 0, 0));
        this.cmdDelete1.setDoubleBuffered(true);
        this.cmdDelete1.setFocusPainted(true);
        this.cmdDelete1.setFont(new Font("Tahoma", 1, 12));
        this.cmdDelete1.setIconAlignment(ButtonRenderer.Alignment.LeftCenter);
        this.cmdDelete1.setMaximumSize(new Dimension(79, 22));
        this.cmdDelete1.setMinimumSize(new Dimension(79, 22));
        this.cmdDelete1.setPreferredSize(new Dimension(79, 22));
        this.cmdDelete1.setShiftOnPress(true);
        this.cmdDelete1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmMutator.this.cmdDelete1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.cmdDown, -1, -1, Short.MAX_VALUE).addComponent((Component)this.cmdLast, -2, 0, Short.MAX_VALUE).addComponent((Component)this.cmdDelete, -2, 0, Short.MAX_VALUE).addComponent((Component)this.cmdUp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent((Component)this.cmdDelete1, -2, 147, -2)).addComponent((Component)this.cmdFirst, -2, 147, -2)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGap(0, 0, 0).addComponent((Component)this.cmdFirst, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdUp, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdDown, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdLast, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdDelete, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cmdDelete1, -2, 33, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 243, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel4, -2, -1, -2)).addComponent(this.jScrollPane2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 131, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        this.listModel.remove(this.lstMutations.getSelectedIndex());
    }

    private void cmdFirstActionPerformed(ActionEvent evt) {
        this.moveItem(this.lstMutations.getSelectedIndex(), 0, this.lstMutations.getSelectedIndex());
    }

    private void cmdUpActionPerformed(ActionEvent evt) {
        int cIndex = this.lstMutations.getSelectedIndex();
        this.moveItem(cIndex, cIndex - 1, cIndex - 1);
    }

    private void cmdDownActionPerformed(ActionEvent evt) {
        int cIndex = this.lstMutations.getSelectedIndex();
        this.moveItem(cIndex, cIndex + 1, cIndex + 1);
    }

    private void cmdLastActionPerformed(ActionEvent evt) {
        this.moveItem(this.lstMutations.getSelectedIndex(), this.listModel.getSize() - 1, this.lstMutations.getSelectedIndex());
    }

    private void moveItem(int cIndex, int newIndex, int newSelectedIndex) {
        int size = this.listModel.getSize();
        if (cIndex >= 0 && cIndex < size && newIndex >= 0 && newIndex < size) {
            this.listModel.moveItemTo(cIndex, newIndex);
            if (newSelectedIndex < 0) {
                newSelectedIndex = 0;
            } else if (newSelectedIndex >= size) {
                newSelectedIndex = size - 1;
            }
            this.lstMutations.setSelectedIndex(newSelectedIndex);
            this.lstMutations.ensureIndexIsVisible(newSelectedIndex);
        }
    }

    private void cmdAddBatchActionPerformed(ActionEvent evt) {
        this.addBatchMutation();
    }

    private void addBatchMutation() {
        if (this.txtBatchMutations.getText().length() == 0) {
            return;
        }
        String tmpMuts = this.txtBatchMutations.getText();
        tmpMuts = tmpMuts.replace(" ", "\n").replace("+", "\n").replace("\t", "\n");
        String[] tmpArray = tmpMuts.split("\n");
        for (int x = 0; x < tmpArray.length; ++x) {
            MutationAnnotation m = MutationAnnotation.from((String)tmpArray[x]);
            if (m == null || !this.tester.isMutationValid(m)) continue;
            this.listModel.add(m);
        }
    }

    private void addDNAMutation() {
        MutationAnnotation m = MutationAnnotation.from((String)("c." + this.txtDNANum.getText() + this.txtOrigDNA.getText() + ">" + this.cmbDNA.getSelectedItem()));
        if (m != null && this.tester.isDNAMutationValid(m)) {
            this.listModel.add(m);
        }
    }

    private void addAAMutation() {
        MutationAnnotation m = MutationAnnotation.from((String)("p." + this.txtOrigAA.getText() + this.txtCodonNum.getText() + ((AAListItem)this.cmbAA.getSelectedItem()).aaa));
        if (m != null && this.tester.isAAMutationValid(m)) {
            this.listModel.add(m);
        }
    }

    private void cmdAddBpActionPerformed(ActionEvent evt) {
        this.addDNAMutation();
    }

    private void cmdAddCodonActionPerformed(ActionEvent evt) {
        AAListItem aa = (AAListItem)this.cmbAA.getSelectedItem();
        if (!aa.equals(this.txtOrigAA.getText())) {
            this.addAAMutation();
        }
    }

    private void cmdDelete1ActionPerformed(ActionEvent evt) {
        this.listModel.clear();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmMutator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmMutator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmMutator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmMutator.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmMutator dialog = new FrmMutator((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class AnnotationListModel
    extends AbstractListModel<MutationAnnotation> {
        ArrayList<MutationAnnotation> mutations = new ArrayList();

        AnnotationListModel() {
        }

        @Override
        public int getSize() {
            return this.mutations.size();
        }

        @Override
        public MutationAnnotation getElementAt(int i) {
            return this.mutations.get(i);
        }

        public void add(MutationAnnotation mutation) {
            if (mutation.isValid()) {
                this.insert(mutation, this.mutations.size());
            }
        }

        public void insert(MutationAnnotation mutation, int index) {
            if (mutation.isValid() && !this.contains(mutation)) {
                this.mutations.add(index, mutation);
                this.fireIntervalAdded(FrmMutator.this.lstMutations, this.mutations.size() - 1, this.mutations.size() - 1);
                FrmMutator.this.mutate();
            }
        }

        public void remove(MutationAnnotation mutation) {
            this.mutations.remove(mutation);
            this.fireIntervalRemoved(FrmMutator.this.lstMutations, this.mutations.size() - 1, this.mutations.size() - 1);
            FrmMutator.this.mutate();
        }

        public void remove(int index) {
            this.mutations.remove(index);
            this.fireIntervalRemoved(FrmMutator.this.lstMutations, index, index);
            FrmMutator.this.mutate();
        }

        public void clear() {
            this.mutations.clear();
            this.fireContentsChanged(FrmMutator.this.lstMutations, -1, -1);
            FrmMutator.this.mutate();
        }

        public void moveItemTo(int cIndex, int newIndex) {
            MutationAnnotation m = this.mutations.get(cIndex);
            this.mutations.remove(cIndex);
            this.mutations.add(newIndex, m);
            this.fireContentsChanged(FrmMutator.this.lstMutations, cIndex, newIndex);
            FrmMutator.this.mutate();
        }

        private boolean contains(MutationAnnotation m) {
            for (MutationAnnotation mut : this.mutations) {
                if (mut.toString().equals(m.toString())) {
                    return true;
                }
                if (mut.get_DNAStart() == m.get_DNAStart()) {
                    return true;
                }
                if ((mut.get_DNAStart() > m.get_DNAStart() || mut.get_DNAStop() < m.get_DNAStart()) && (mut.get_DNAStart() > m.get_DNAStop() || mut.get_DNAStop() < m.get_DNAStop())) continue;
                return true;
            }
            return false;
        }
    }

    private static class AAListItem {
        private char a;
        private String aaa;
        private String name;

        public AAListItem(char a, String aaa, String name) {
            this.a = a;
            this.aaa = aaa;
            this.name = name;
        }

        public boolean equals(String aaa) {
            return this.aaa.equalsIgnoreCase(aaa);
        }

        public boolean equals(AAListItem aa) {
            return this.aaa.equalsIgnoreCase(aa.aaa);
        }

        public String toString() {
            return this.aaa + " (" + this.a + ", " + this.name + ")";
        }
    }
}

