/*
 * Decompiled with CFR 0.152.
 */
package Gibson;

import DNATools.DegenerateFinder;
import DNATools.TmCalculator;
import GenbankFileReader.Locus;
import Gibson.Fragment;
import Gibson.GibsonPrimer;
import Gibson.GibsonPrimerPair;
import Sequences.DNA;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import plot.Feature;

class GibsonPrimerMaker {
    private String error = "";
    public static final int MIN_PBS_LEN = 19;
    public static final int MIN_HA_LEN = 20;
    public static final int MAX_PBS_GC = 55;
    public static final int MIN_PBS_TM = 55;
    protected static int min_PBS_Len = 19;
    protected static int min_HA_Len = 20;
    protected static int max_PBS_GC = 55;
    protected static int min_PBS_tm = 55;
    protected int tm_Calc_Type = 3;
    public static final int TM_CALC_TYPE = 3;
    private List<Fragment> inserts = new ArrayList<Fragment>();
    private Fragment vector = null;
    boolean processed = false;
    private boolean makeVectorPrimers = true;
    private List<GibsonPrimer> madePrimers = new ArrayList<GibsonPrimer>();
    String finalSeq = null;
    ArrayList<Feature> features = new ArrayList();
    static Color primerColor = Color.GREEN.darker().darker();

    GibsonPrimerMaker() {
    }

    public int getMin_PBS_Len() {
        return min_PBS_Len;
    }

    public void setMin_PBS_Len(int len) {
        if (len != min_PBS_Len && len > 14) {
            min_PBS_Len = len;
            this.resetInternal();
        }
    }

    public int getMin_HA_Len() {
        return min_HA_Len;
    }

    public void setMin_HA_Len(int len) {
        if (len != min_HA_Len && len > 14) {
            min_HA_Len = len;
            this.resetInternal();
        }
    }

    public int getMax_PBS_GC() {
        return max_PBS_GC;
    }

    public void setMax_PBS_GC(int gc) {
        if (max_PBS_GC != gc) {
            max_PBS_GC = gc;
            this.resetInternal();
        }
    }

    public int getMin_PBS_tm() {
        return min_PBS_tm;
    }

    public void setMin_PBS_tm(int tm) {
        if (tm != min_PBS_tm && tm > 45) {
            min_PBS_tm = tm;
            this.resetInternal();
        }
    }

    public int getTm_Calc_Type() {
        return this.tm_Calc_Type;
    }

    public void setTm_Calc_Type(int calc_Type) {
        if (this.tm_Calc_Type != calc_Type) {
            switch (calc_Type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.tm_Calc_Type = calc_Type;
                    this.resetInternal();
                }
            }
        }
    }

    public String getError() {
        return this.error;
    }

    private void process(Fragment vector, boolean makeVectorPrimers, List<Fragment> inserts) {
        GibsonPrimerPair pair;
        this.madePrimers.clear();
        this.features.clear();
        String seq = this.getSequence();
        if (seq == null || seq.length() == 0) {
            return;
        }
        int seqLen = seq.length();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        GibsonPrimer prevPrimer = null;
        if (vector != null) {
            fragments.add(vector);
        }
        for (Fragment f : inserts) {
            fragments.add(f);
        }
        int count = fragments.size();
        int bp = 0;
        for (int x = 0; x < count - 1; ++x) {
            Fragment left = (Fragment)fragments.get(x);
            Fragment right = (Fragment)fragments.get(x + 1);
            boolean revOH = x > 0 || vector == null || makeVectorPrimers;
            boolean fwdOH = x < count - 1 || vector == null || makeVectorPrimers;
            pair = this.makePrimersPair(left, right, revOH, fwdOH);
            if (pair.fwdPrimer != null) {
                pair.fwdPrimer.adjust(bp, seqLen);
            }
            if (pair.revPrimer != null) {
                pair.revPrimer.adjust(bp, seqLen);
            }
            if (left.suffix.length() + right.prefix.length() > 0) {
                Feature f = new Feature();
                f.setName("Non-template Sequence");
                f.setWidth(3);
                int start = bp + left.prefix.length() + left.sequence.length();
                f.set(start + 1, start + left.suffix.length() + right.prefix.length(), false);
                f.setColor(Color.ORANGE);
                f.setGraphicStyle(Feature.GraphicStyle.Box);
                this.features.add(f);
                System.out.println(f);
            }
            bp += left.length(2);
            if (prevPrimer != null) {
                this.featuresAdd(this.primersToPCR(prevPrimer, pair.revPrimer, left.getName()));
            }
            prevPrimer = pair.fwdPrimer;
        }
        Fragment left = (Fragment)fragments.get(count - 1);
        Fragment right = (Fragment)fragments.get(0);
        boolean revOH = true;
        boolean fwdOH = vector == null || makeVectorPrimers;
        pair = this.makePrimersPair(left, right, revOH, fwdOH);
        if (pair.fwdPrimer != null) {
            pair.fwdPrimer.adjust(bp, seqLen);
        }
        if (pair.revPrimer != null) {
            pair.revPrimer.adjust(bp, seqLen);
        }
        if (prevPrimer != null) {
            this.featuresAdd(this.primersToPCR(prevPrimer, pair.revPrimer, prevPrimer.name));
        }
        if (left.suffix.length() + right.prefix.length() > 0) {
            Feature f = new Feature();
            f.setName("Non-template Sequence");
            f.setWidth(3);
            int start = bp + left.prefix.length() + left.sequence.length();
            f.set(start + 1, start + left.suffix.length() + right.prefix.length(), false);
            f.setColor(Color.ORANGE);
            f.setGraphicStyle(Feature.GraphicStyle.Box);
            this.features.add(f);
            System.out.println(f);
        }
        if (vector == null || makeVectorPrimers) {
            this.featuresAdd(this.primersToPCR(pair.fwdPrimer, this.madePrimers.get(1), right.getName()));
        }
        this.madePrimers.sort(new Comparator<GibsonPrimer>(){

            @Override
            public int compare(GibsonPrimer o1, GibsonPrimer o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        this.genROI();
    }

    private GibsonPrimerPair makePrimersPair(Fragment seq1, Fragment seq2, boolean revOverHang, boolean fwdOverHang) {
        String comment;
        GibsonPrimerPair outPrimers = new GibsonPrimerPair();
        DNA tmpDNA = new DNA();
        String mergedSeq = seq1.getSequence(2).toLowerCase() + seq2.getSequence(2).toLowerCase();
        tmpDNA.setSequence(mergedSeq);
        outPrimers.fwdPrimer.start = seq1.sequence.length() + seq1.suffix.length() + seq1.prefix.length() + seq2.prefix.length() + 1;
        outPrimers.revPrimer.stop = seq1.sequence.length() + seq1.prefix.length();
        outPrimers.revPrimer.isAntisense = true;
        boolean lenOK = false;
        if (fwdOverHang) {
            outPrimers.fwdPrimer.stop = outPrimers.fwdPrimer.start + (min_PBS_Len - 1);
            while (outPrimers.fwdPrimer.stop < tmpDNA.length()) {
                int fwdTm = TmCalculator.getTm((String)tmpDNA.getSequence(outPrimers.fwdPrimer.start, outPrimers.fwdPrimer.stop), (int)this.tm_Calc_Type);
                if (fwdTm >= min_PBS_tm) {
                    outPrimers.fwdPrimer.tmPBS = fwdTm;
                    outPrimers.fwdPrimer.pbsLen = outPrimers.fwdPrimer.stop - outPrimers.fwdPrimer.start + 1;
                    lenOK = true;
                    break;
                }
                ++outPrimers.fwdPrimer.stop;
            }
            if (!lenOK) {
                outPrimers.fwdPrimer.comment = "Fwd Primer could not be extended to meet minimum Tm.";
                return outPrimers;
            }
        }
        if (revOverHang) {
            lenOK = false;
            outPrimers.revPrimer.start = outPrimers.revPrimer.stop - min_PBS_Len + 1;
            while (outPrimers.revPrimer.start > 0) {
                int revTm = TmCalculator.getTm((String)tmpDNA.getSequence(outPrimers.revPrimer.start, outPrimers.revPrimer.stop), (int)this.tm_Calc_Type);
                if (revTm >= min_PBS_tm) {
                    outPrimers.revPrimer.tmPBS = revTm;
                    outPrimers.revPrimer.pbsLen = outPrimers.revPrimer.stop - outPrimers.revPrimer.start + 1;
                    lenOK = true;
                    break;
                }
                --outPrimers.revPrimer.start;
            }
            if (!lenOK) {
                outPrimers.revPrimer.comment = "Rev Primer could not be extended to meet minimum Tm.";
                return outPrimers;
            }
        }
        if (revOverHang && fwdOverHang) {
            int fwdLen = outPrimers.fwdPrimer.stop - outPrimers.fwdPrimer.start + 1;
            int revLen = outPrimers.revPrimer.stop - outPrimers.revPrimer.start + 1;
            int ol1 = min_HA_Len;
            while (outPrimers.revPrimer.stop - outPrimers.fwdPrimer.start < ol1) {
                if (revLen <= fwdLen) {
                    ++outPrimers.revPrimer.stop;
                    ++revLen;
                    continue;
                }
                --outPrimers.fwdPrimer.start;
                ++fwdLen;
            }
        } else if (revOverHang) {
            outPrimers.revPrimer.stop = seq1.suffix.length() + seq1.sequence.length() + seq1.prefix.length() + seq2.prefix.length() + min_HA_Len;
        } else if (fwdOverHang) {
            outPrimers.fwdPrimer.start = seq1.suffix.length() + seq1.sequence.length() - min_HA_Len;
        }
        tmpDNA.toUppercase(outPrimers.fwdPrimer.start, outPrimers.revPrimer.stop);
        String string = comment = outPrimers.comment.length() == 0 ? "Tm calculated for " + TmCalculator.getTmTypeName((int)this.tm_Calc_Type) : outPrimers.comment + ".  Tm calculated for " + TmCalculator.getTmTypeName((int)this.tm_Calc_Type);
        if (fwdOverHang) {
            outPrimers.fwdPrimer.sequence = tmpDNA.getSequence(outPrimers.fwdPrimer.start, outPrimers.fwdPrimer.stop);
            outPrimers.fwdPrimer.name = seq2.getName() + "_F";
            outPrimers.fwdPrimer.comment = "Gibson assembly primer with overlap to " + (revOverHang ? "primer " + seq1.getName() + "_R" : seq1.getName()) + ". " + comment;
            this.madePrimers.add(outPrimers.fwdPrimer);
        } else {
            outPrimers.fwdPrimer = null;
        }
        if (revOverHang) {
            outPrimers.revPrimer.sequence = tmpDNA.getSequence(outPrimers.revPrimer.start, outPrimers.revPrimer.stop, true);
            outPrimers.revPrimer.name = seq1.getName() + "_R";
            outPrimers.revPrimer.comment = "Gibson assembly primer with overlap to " + (fwdOverHang ? "primer " + seq2.getName() + "_F" : seq2.getName()) + ". " + comment;
            this.madePrimers.add(outPrimers.revPrimer);
        } else {
            outPrimers.revPrimer = null;
        }
        this.processed = true;
        return outPrimers;
    }

    public boolean addFragment(String name, String sequence) {
        this.resetInternal();
        Fragment f = Fragment.fragFromString(sequence);
        if (f.isValid()) {
            f.setName(name != null && name.length() > 0 && name.trim().length() > 0 ? name.trim() : "fragment_" + this.inserts.size());
            this.inserts.add(f);
            return true;
        }
        this.error = f.getError();
        return false;
    }

    public void clear() {
        this.inserts.clear();
        this.resetInternal();
    }

    private void resetInternal() {
        this.error = null;
        this.finalSeq = null;
        this.madePrimers.clear();
        this.processed = false;
        this.features.clear();
    }

    public boolean setVector(String name, String sequence) {
        this.resetInternal();
        Fragment f = Fragment.fragFromString(sequence);
        if (f.isValid() && f.sequence.length() > 0) {
            if (f.getSequence(0).length() >= 40) {
                f.setName(name != null && name.length() > 0 && name.trim().length() > 0 ? name.trim() : "fragment_" + this.inserts.size());
                this.vector = f;
                return true;
            }
            this.error = "Vector backbone is too short (must be > 40bp)";
            return false;
        }
        this.vector = null;
        return true;
    }

    public boolean isMakeVectorPrimers() {
        return this.makeVectorPrimers;
    }

    public void setMakeVectorPrimers(boolean make) {
        if (this.makeVectorPrimers != make) {
            this.makeVectorPrimers = make;
            this.resetInternal();
        }
    }

    public List<GibsonPrimer> getPrimers() {
        if (!this.processed) {
            this.process(this.vector, this.makeVectorPrimers, this.inserts);
        }
        return this.madePrimers;
    }

    public String getSequence() {
        if (this.finalSeq == null) {
            StringBuilder sb = new StringBuilder();
            if (this.vector != null) {
                sb.append(this.vector.getSequence(2));
            }
            for (Fragment f : this.inserts) {
                sb.append(f.getSequence(2));
            }
            this.finalSeq = sb.toString();
        }
        return this.finalSeq;
    }

    private void genROI() {
        int currentPos = 1;
        if (this.vector != null) {
            Feature v = new Feature();
            v.setName(this.vector.getName());
            v.set(1, this.vector.length());
            v.setWidth(3);
            v.setGraphicStyle(Feature.GraphicStyle.Box);
            v.setColor(Color.LIGHT_GRAY);
            this.features.add(v);
            currentPos += this.vector.length();
        }
        for (Fragment insert : this.inserts) {
            String fName = insert.getName();
            String fSeq = insert.getSequence(2);
            Feature f = new Feature();
            f.setName(fName);
            f.set(currentPos, fSeq.length() + currentPos - 1);
            f.setWidth(3);
            f.setGraphicStyle(Feature.GraphicStyle.HeadlessArrow);
            currentPos += fSeq.length();
            this.features.add(f);
        }
        String seq = this.getSequence();
        this.addPrimerLocations(seq, this.madePrimers, this.features);
    }

    public List<Feature> getROI() {
        if (!this.processed) {
            this.process(this.vector, this.makeVectorPrimers, this.inserts);
        }
        ArrayList<Feature> tmpfeatures = new ArrayList<Feature>();
        for (Feature f : this.features) {
            tmpfeatures.add(f);
        }
        return tmpfeatures;
    }

    public boolean hasVector() {
        return this.vector != null;
    }

    private void addPrimerLocations(String seq, List<GibsonPrimer> primers, List<Feature> accumulator) {
        DegenerateFinder finder = new DegenerateFinder(seq, true);
        if (primers != null && !primers.isEmpty()) {
            for (GibsonPrimer p : primers) {
                Locus[] results2 = finder.findDNASequence(p.sequence, true, true);
                if (results2 == null || results2.length <= 0) continue;
                for (Locus pos : results2) {
                    Feature f = this.primerToROI(p);
                    f.set(pos.getStart(), pos.getStop(), pos.isAntisense());
                    accumulator.add(f);
                }
            }
        }
    }

    private Feature primerToROI(GibsonPrimer p) {
        if (p != null) {
            Feature f = new Feature(p.name, p.start, p.stop, p.isAntisense, Feature.GraphicStyle.HeadlessArrow, primerColor, primerColor);
            f.setGBType("primer_bind");
            f.setOffset(p.isAntisense ? 87 : 107);
            f.setWidth(3);
            f.setNote(p.comment);
            return f;
        }
        return null;
    }

    private Feature primersToPCR(GibsonPrimer pF, GibsonPrimer pR, String name) {
        if (pF != null && pR != null) {
            Feature f = this.primerToROI(pF);
            f.setStop(pR.stop);
            if (name.length() > 3 && (name.endsWith("_R") || name.endsWith("_F"))) {
                name = name.substring(0, name.length() - 2);
            }
            f.setName(name + " PCR product");
            f.setNote("Generated using primers\n" + pF.name + "(" + pF.sequence + ")\n+\n" + pR.name + "(" + pR.sequence + ")");
            f.setGBType("misc_feature");
            f.setAntisense(false);
            f.setOffset(93);
            f.setWidth(3);
            return f;
        }
        return null;
    }

    private void featuresAdd(Feature f) {
        if (f != null) {
            this.features.add(f);
        }
    }
}

