/*
 * Decompiled with CFR 0.152.
 */
package Gibson;

import Sequences.DNA;

class Fragment {
    public static final int SEQ_MAIN = 0;
    public static final int SEQ_PREFIX_MAIN = 1;
    public static final int SEQ_PREFIX_MAIN_SUFFIX = 2;
    public static final int SEQ_MAIN_SUFFIX = 3;
    public static final int SEQ_PREFIX = 4;
    public static final int SEQ_SUFFIX = 5;
    String sequence = "";
    String prefix = "";
    String suffix = "";
    private String name = "";
    private boolean isValid = false;
    String error = "";

    public static Fragment fragFromString(String input) {
        Fragment f = new Fragment();
        if (input == null || input.length() == 0) {
            f.error = "Empty or null input";
            return f;
        }
        String header = null;
        String main = input.trim();
        String footer = null;
        if (main.startsWith("[")) {
            int endBracket = main.indexOf(93);
            if (endBracket <= 0) {
                f.error = "Invalid header format: missing closing bracket";
                return f;
            }
            header = main.substring(1, endBracket);
            main = main.substring(endBracket + 1);
            if (header.contains("[")) {
                f.error = "Invalid header format: nested bracket";
                return f;
            }
        }
        if (main.endsWith("]")) {
            int startBracket = main.lastIndexOf(91);
            if (startBracket < 0) {
                f.error = "Invalid footer format: missing opening bracket";
                return f;
            }
            if (main.indexOf(91, startBracket + 1) != -1) {
                f.error = "Invalid footer format: extra bracket in footer";
                return f;
            }
            footer = main.substring(startBracket + 1, main.length() - 1);
            main = main.substring(0, startBracket);
            if (footer.contains("]")) {
                f.error = "Invalid footer format: nested bracket";
                return f;
            }
        }
        if (main.contains("[") || main.contains("]")) {
            f.error = "Invalid format: stray bracket in main string";
            return f;
        }
        if (main != null) {
            f.sequence = main = DNA.filterSequence((String)main);
        }
        if (header != null) {
            f.prefix = header = DNA.filterSequence((String)header);
        }
        if (footer != null) {
            f.suffix = footer = DNA.filterSequence(footer);
        }
        f.isValid = true;
        return f;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getError() {
        return this.error;
    }

    public void setName(String name) {
        if (name != null) {
            this.name = name.trim();
        }
    }

    public String getName() {
        return this.name != null && this.name.length() > 0 ? this.name : "fragment";
    }

    public String getSequence() {
        return this.prefix + this.sequence + this.suffix;
    }

    public String getSequence(int format) {
        switch (format) {
            case 0: {
                return this.sequence;
            }
            case 1: {
                return this.prefix + this.sequence;
            }
            case 3: {
                return this.sequence + this.suffix;
            }
            case 4: {
                return this.prefix;
            }
            case 5: {
                return this.suffix;
            }
        }
        return this.prefix + this.sequence + this.suffix;
    }

    public int length() {
        return this.prefix.length() + this.suffix.length() + this.sequence.length();
    }

    public int length(int format) {
        switch (format) {
            case 0: {
                return this.sequence.length();
            }
            case 1: {
                return this.prefix.length() + this.sequence.length();
            }
            case 3: {
                return this.sequence.length() + this.suffix.length();
            }
            case 4: {
                return this.prefix.length();
            }
            case 5: {
                return this.suffix.length();
            }
        }
        return this.prefix.length() + this.suffix.length() + this.sequence.length();
    }

    public String toString() {
        return this.name + "(len = " + this.length() + ")";
    }
}

